Liferay.Loader.define("dynamic-data-mapping-form-report-web@1.0.19/js/utils/data.es", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.toArray = exports.sumTotalEntries = exports.roundPercentage = exports.removeEmptyValues = exports.getColumnLabel = exports["default"] = void 0;

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var getColumnLabel = function getColumnLabel(column, field) {
      return field.columns[column] ? field.columns[column].value : undefined;
    };

    exports.getColumnLabel = getColumnLabel;

    var removeEmptyValues = function removeEmptyValues(values) {
      return Array.isArray(values) && values.filter(function (value) {
        return value;
      });
    };

    exports.removeEmptyValues = removeEmptyValues;

    var roundPercentage = function roundPercentage(value) {
      return "".concat(Math.trunc(value * 1000) / 10, "%");
    };

    exports.roundPercentage = roundPercentage;

    var sumTotalEntries = function sumTotalEntries(values) {
      return Object.values(values).reduce(function (acc, value) {
        return acc + value;
      }, 0);
    };

    exports.sumTotalEntries = sumTotalEntries;

    var toArray = function toArray(values) {
      return values.map(function (_ref) {
        var value = _ref.value;
        return value;
      });
    };

    exports.toArray = toArray;

    var toDataArray = function toDataArray(options, values) {
      return Object.entries(values).map(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
            name = _ref3[0],
            count = _ref3[1];

        return {
          count: count,
          label: options[name] ? options[name].value : name
        };
      }).sort(function (a, b) {
        return a.count > b.count ? -1 : b.count > a.count ? 1 : 0;
      });
    };

    var _default = toDataArray;
    exports["default"] = _default;
    //# sourceMappingURL=data.es.js.map
  }
});
//# sourceMappingURL=data.es.js.map