Liferay.Loader.define("dynamic-data-mapping-form-report-web@1.0.19/js/components/chart/pie/PieChart.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'frontend-js-recharts$recharts', '../../../utils/colors.es', '../../../utils/data.es', '../Legend.es', '../TooltipContent.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _recharts = require("frontend-js-recharts$recharts");

    var _colors = _interopRequireDefault(require("../../../utils/colors.es"));

    var _data = require("../../../utils/data.es");

    var _Legend = _interopRequireDefault(require("../Legend.es"));

    var _TooltipContent = _interopRequireDefault(require("../TooltipContent.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var RADIAN = Math.PI / 180;

    var _default = function _default(_ref) {
      var data = _ref.data,
          height = _ref.height,
          totalEntries = _ref.totalEntries,
          width = _ref.width;

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          activeIndex = _useState2[0],
          setActiveIndex = _useState2[1];

      var _useState3 = (0, _react.useState)(true),
          _useState4 = _slicedToArray(_useState3, 2),
          isAnimationActive = _useState4[0],
          setAnimationActive = _useState4[1];

      var handleOnMouseOut = function handleOnMouseOut() {
        setActiveIndex(null);
      };

      var handleOnMouseOver = function handleOnMouseOver(index) {
        setActiveIndex(index);
      };

      return _react["default"].createElement(_react["default"].Fragment, null, _react["default"].createElement(_recharts.ResponsiveContainer, {
        height: height || '99%',
        width: width || '50%'
      }, _react["default"].createElement(_recharts.PieChart, null, _react["default"].createElement(_recharts.Pie, {
        activeIndex: activeIndex,
        activeShape: function ActiveShape(_ref2) {
          var cx = _ref2.cx,
              cy = _ref2.cy,
              endAngle = _ref2.endAngle,
              innerRadius = _ref2.innerRadius,
              outerRadius = _ref2.outerRadius,
              startAngle = _ref2.startAngle;
          setAnimationActive(false);
          return _react["default"].createElement("g", null, _react["default"].createElement(_recharts.Sector, {
            cx: cx,
            cy: cy,
            endAngle: endAngle,
            fill: (0, _colors["default"])(activeIndex),
            innerRadius: innerRadius,
            onMouseOut: handleOnMouseOut,
            outerRadius: outerRadius + 5,
            startAngle: startAngle
          }));
        },
        cx: "50%",
        cy: "50%",
        data: data,
        dataKey: "count",
        innerRadius: 80,
        isAnimationActive: isAnimationActive,
        label: function Label(_ref3) {
          var cx = _ref3.cx,
              cy = _ref3.cy,
              innerRadius = _ref3.innerRadius,
              midAngle = _ref3.midAngle,
              outerRadius = _ref3.outerRadius,
              percent = _ref3.percent;
          var radius = innerRadius + (outerRadius - innerRadius) * 0.5;
          var x = cx + radius * Math.cos(-midAngle * RADIAN);
          var y = cy + radius * Math.sin(-midAngle * RADIAN);
          return _react["default"].createElement("text", {
            dominantBaseline: "central",
            fill: "white",
            textAnchor: "middle",
            x: x,
            y: y
          }, (0, _data.roundPercentage)(percent));
        },
        labelLine: false,
        nameKey: "label",
        onMouseOver: function onMouseOver(_, index) {
          return handleOnMouseOver(index);
        },
        outerRadius: 135,
        paddingAngle: 0
      }, data.map(function (_, index) {
        return _react["default"].createElement(_recharts.Cell, {
          fill: (0, _colors["default"])(index),
          key: index
        });
      })), _react["default"].createElement(_recharts.Tooltip, {
        content: _react["default"].createElement(_TooltipContent["default"], {
          showBullet: true,
          showHeader: false,
          totalEntries: totalEntries
        })
      }))), _react["default"].createElement(_Legend["default"], {
        activeIndex: activeIndex,
        labels: data.map(function (_ref4) {
          var label = _ref4.label;
          return label;
        }),
        onMouseOut: handleOnMouseOut,
        onMouseOver: handleOnMouseOver
      }));
    };

    exports["default"] = _default;
    //# sourceMappingURL=PieChart.es.js.map
  }
});
//# sourceMappingURL=PieChart.es.js.map