Liferay.Loader.define("dynamic-data-mapping-form-report-web@1.0.19/js/components/chart/bar/CustomizedAxisTick.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', 'frontend-js-recharts$recharts', '../../../utils/ellipsize.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _recharts = require("frontend-js-recharts$recharts");

    var _ellipsize = _interopRequireDefault(require("../../../utils/ellipsize.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var MAX_TEXT_SIZE = 34;
    var MAX_WIDTH = 220;
    var MIN_TICKS_TO_MINIMIZE = 5;
    var MIN_TICKS_TO_ELLIPSIZE = 2;
    var SPACING_SIZE = 17;

    var minimize = function minimize(ticksNumber) {
      return ticksNumber > MIN_TICKS_TO_MINIMIZE ? MAX_TEXT_SIZE / Math.log(ticksNumber) : MAX_TEXT_SIZE;
    };

    var _default = function _default(_ref) {
      var payload = _ref.payload,
          ticksNumber = _ref.ticksNumber,
          x = _ref.x,
          y = _ref.y;
      return _react["default"].createElement(_recharts.Text, {
        textAnchor: "middle",
        verticalAnchor: "start",
        width: MAX_WIDTH - ticksNumber * SPACING_SIZE,
        x: x,
        y: y
      }, payload.value.length > MAX_TEXT_SIZE && ticksNumber > MIN_TICKS_TO_ELLIPSIZE ? (0, _ellipsize["default"])(payload.value, minimize(ticksNumber)) : payload.value);
    };

    exports["default"] = _default;
    //# sourceMappingURL=CustomizedAxisTick.es.js.map
  }
});
//# sourceMappingURL=CustomizedAxisTick.es.js.map