Liferay.Loader.define("dynamic-data-mapping-form-report-web@1.0.19/js/components/card/CardList.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../utils/data.es', '../../utils/fieldTypes.es', '../chart/bar/MultiBarChart.es', '../chart/bar/SimpleBarChart.es', '../chart/pie/PieChart.es', '../empty-state/EmptyState.es', '../list/List.es', './Card.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = void 0;

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _data = _interopRequireWildcard(require("../../utils/data.es"));

    var _fieldTypes = _interopRequireDefault(require("../../utils/fieldTypes.es"));

    var _MultiBarChart = _interopRequireDefault(require("../chart/bar/MultiBarChart.es"));

    var _SimpleBarChart = _interopRequireDefault(require("../chart/bar/SimpleBarChart.es"));

    var _PieChart = _interopRequireDefault(require("../chart/pie/PieChart.es"));

    var _EmptyState = _interopRequireDefault(require("../empty-state/EmptyState.es"));

    var _List = _interopRequireDefault(require("../list/List.es"));

    var _Card = _interopRequireDefault(require("./Card.es"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj["default"] = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var chartFactory = function chartFactory(_ref) {
      var field = _ref.field,
          structure = _ref.structure,
          summary = _ref.summary,
          totalEntries = _ref.totalEntries,
          values = _ref.values;
      var options = field.options,
          type = field.type;

      switch (type) {
        case 'checkbox_multiple':
          return _react["default"].createElement(_SimpleBarChart["default"], {
            data: (0, _data["default"])(options, values),
            totalEntries: totalEntries
          });

        case 'numeric':
          {
            if (Array.isArray(values)) {
              return _react["default"].createElement(_List["default"], {
                data: (0, _data.toArray)(values),
                field: field,
                summary: summary,
                totalEntries: totalEntries
              });
            } else {
              return '';
            }
          }

        case 'grid':
          {
            return _react["default"].createElement(_MultiBarChart["default"], {
              data: values,
              field: field,
              structure: structure,
              totalEntries: totalEntries
            });
          }

        case 'radio':
        case 'select':
          return _react["default"].createElement(_PieChart["default"], {
            data: (0, _data["default"])(options, values),
            totalEntries: totalEntries
          });

        case 'color':
        case 'date':
        case 'text':
          {
            if (Array.isArray(values)) {
              return _react["default"].createElement(_List["default"], {
                data: (0, _data.toArray)(values),
                field: field,
                totalEntries: totalEntries,
                type: type
              });
            } else {
              return '';
            }
          }

        default:
          return null;
      }
    };

    var _default = function _default(_ref2) {
      var data = _ref2.data,
          fields = _ref2.fields;
      var hasCards = false;
      var cards = fields.map(function (field, index) {
        var _ref3 = data[field.name] || {},
            _ref3$values = _ref3.values,
            values = _ref3$values === void 0 ? {} : _ref3$values,
            _ref3$structure = _ref3.structure,
            structure = _ref3$structure === void 0 ? {} : _ref3$structure,
            _ref3$summary = _ref3.summary,
            summary = _ref3$summary === void 0 ? {} : _ref3$summary,
            _ref3$totalEntries = _ref3.totalEntries,
            totalEntries = _ref3$totalEntries === void 0 ? (0, _data.sumTotalEntries)(values) : _ref3$totalEntries;

        field = _objectSpread({}, field, {}, _fieldTypes["default"][field.type]);
        var chartContent = {
          field: field,
          structure: structure,
          summary: summary,
          totalEntries: totalEntries,
          values: values
        };
        var chart = chartFactory(chartContent);

        if (chart === null) {
          return null;
        } else {
          hasCards = true;
        }

        return _react["default"].createElement(_Card["default"], {
          field: field,
          index: index,
          key: index,
          summary: summary,
          totalEntries: totalEntries
        }, chart);
      });

      if (!hasCards) {
        return _react["default"].createElement(_EmptyState["default"], null);
      }

      return cards;
    };

    exports["default"] = _default;
    //# sourceMappingURL=CardList.es.js.map
  }
});
//# sourceMappingURL=CardList.es.js.map