Liferay.Loader.define("dynamic-data-mapping-form-renderer@5.0.34/js/components/MultiStep.es", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$react', '../actions/eventTypes.es', '../hooks/useForm.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.MultiStep = void 0;

  var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

  var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

  var _eventTypes = require("../actions/eventTypes.es");

  var _useForm = require("../hooks/useForm.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  /**
   * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
   *
   * This library is free software; you can redistribute it and/or modify it under
   * the terms of the GNU Lesser General Public License as published by the Free
   * Software Foundation; either version 2.1 of the License, or (at your option)
   * any later version.
   *
   * This library is distributed in the hope that it will be useful, but WITHOUT
   * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
   * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
   * details.
   */
  var MultiStep = function MultiStep(_ref) {
    var activePage = _ref.activePage,
        editable = _ref.editable,
        pages = _ref.pages;
    var dispatch = (0, _useForm.useForm)();
    return _react["default"].createElement("div", {
      className: "ddm-form-pagination position-relative wizard-mode"
    }, _react["default"].createElement("ol", {
      className: "dmm-wizard multi-step-indicator-label-top multi-step-nav multi-step-nav-collapse-sm"
    }, pages.map(function (page, index) {
      return _react["default"].createElement("li", {
        className: (0, _classnames["default"])('multi-step-item', {
          active: index === activePage,
          complete: index < activePage,
          'multi-step-item-expand': index + 1 !== pages.length
        }),
        key: index,
        onClick: function onClick() {
          return dispatch({
            payload: index,
            type: _eventTypes.EVENT_TYPES.CHANGE_ACTIVE_PAGE
          });
        }
      }, _react["default"].createElement("div", {
        className: "multi-step-divider"
      }), _react["default"].createElement("div", {
        className: "multi-step-indicator"
      }, _react["default"].createElement("div", {
        className: "multi-step-indicator-label"
      }, page.paginationItemRenderer === 'wizard_success' ? Liferay.Language.get('success-page') : page.title ? page.title : Liferay.Language.get('untitled-page')), editable ? _react["default"].createElement("a", {
        className: "multi-step-icon",
        "data-multi-step-icon": index + 1,
        href: "javascript:;"
      }) : _react["default"].createElement("span", {
        className: "multi-step-icon",
        "data-multi-step-icon": index + 1
      })));
    })));
  };

  exports.MultiStep = MultiStep;
  //# sourceMappingURL=MultiStep.es.js.map
});
//# sourceMappingURL=MultiStep.es.js.map