Liferay.Loader.define("dynamic-data-mapping-form-renderer@4.0.65/js/util/evaluation.es", ['module', 'exports', 'require', 'frontend-js-web', './fetch.es', './visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.mergePages = exports.mergeFieldOptions = exports.evaluate = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _fetch = require("./fetch.es");

  var _visitors = require("./visitors.es");

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var EVALUATOR_URL = themeDisplay.getPathContext() + '/o/dynamic-data-mapping-form-context-provider/';
  var controller = null;
  var doEvaluate = (0, _frontendJsWeb.debounce)(function (fieldName, evaluatorContext, callback) {
    var defaultLanguageId = evaluatorContext.defaultLanguageId,
        editingLanguageId = evaluatorContext.editingLanguageId,
        pages = evaluatorContext.pages,
        portletNamespace = evaluatorContext.portletNamespace;

    if (controller) {
      controller.abort();
    }

    if (window.AbortController) {
      controller = new AbortController();
    }

    (0, _fetch.makeFetch)({
      body: (0, _fetch.convertToFormData)({
        languageId: editingLanguageId,
        p_auth: Liferay.authToken,
        portletNamespace: portletNamespace,
        serializedFormContext: JSON.stringify(_objectSpread({}, evaluatorContext, {
          groupId: themeDisplay.getScopeGroupId(),
          portletNamespace: portletNamespace
        })),
        trigger: fieldName
      }),
      signal: controller && controller.signal,
      url: EVALUATOR_URL
    }).then(function (newPages) {
      var mergedPages = mergePages(defaultLanguageId, editingLanguageId, fieldName, newPages, pages);
      callback(null, mergedPages);
    })["catch"](function (error) {
      return callback(error);
    });
  }, 600);

  var evaluate = function evaluate(fieldName, evaluatorContext) {
    return new Promise(function (resolve, reject) {
      doEvaluate(fieldName, evaluatorContext, function (error, pages) {
        if (error) {
          return reject(error);
        }

        resolve(pages);
      });
    });
  };

  exports.evaluate = evaluate;

  var mergeFieldOptions = function mergeFieldOptions(field, newField) {
    var newValue = _objectSpread({}, newField.value);

    Object.keys(newValue).forEach(function (languageId) {
      newValue = _objectSpread({}, newValue, _defineProperty({}, languageId, newValue[languageId].map(function (option) {
        var existingOption = field.value[languageId].find(function (_ref) {
          var value = _ref.value;
          return value === option.value;
        });
        return _objectSpread({}, option, {
          edited: existingOption && existingOption.edited
        });
      })));
    });
    return newValue;
  };

  exports.mergeFieldOptions = mergeFieldOptions;

  var mergePages = function mergePages(defaultLanguageId, editingLanguageId, fieldName, newPages, sourcePages) {
    var visitor = new _visitors.PagesVisitor(newPages);
    return visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex) {
      var sourceField = sourcePages[pageIndex].rows[rowIndex].columns[columnIndex].fields[fieldIndex];
      var displayErrors = sourceField.displayErrors || field.fieldName === fieldName;

      var newField = _objectSpread({}, sourceField, {}, field, {
        defaultLanguageId: defaultLanguageId,
        displayErrors: displayErrors,
        editingLanguageId: editingLanguageId,
        valid: field.valid !== false,
        value: field.valueChanged ? field.value : sourceField.value
      });

      if (newField.type === 'captcha') {
        return sourceField;
      }

      if (sourceField.nestedFields && newField.nestedFields) {
        newField = _objectSpread({}, newField, {
          nestedFields: sourceField.nestedFields.map(function (nestedField) {
            return _objectSpread({}, nestedField, {}, newField.nestedFields.find(function (_ref2) {
              var fieldName = _ref2.fieldName;
              return fieldName === nestedField.fieldName;
            }) || {});
          })
        });
      }

      if (newField.type === 'options') {
        newField = _objectSpread({}, newField, {
          value: mergeFieldOptions(sourceField, newField)
        });
      }

      if (newField.localizable) {
        newField = _objectSpread({}, newField, {
          localizedValue: _objectSpread({}, sourceField.localizedValue)
        });
      }

      return newField;
    });
  };

  exports.mergePages = mergePages;
  //# sourceMappingURL=evaluation.es.js.map
});
//# sourceMappingURL=evaluation.es.js.map