/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal.servlet;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutColumn;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormLayoutRow;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMFormTemplateContextProcessor {
    private final DDMForm _ddmForm;
    private final DDMFormLayout _ddmFormLayout;
    private final DDMFormValues _ddmFormValues;
    private long _groupId;
    private final JSONObject _jsonObject;
    private final Locale _locale;

    public DDMFormTemplateContextProcessor(JSONObject jsonObject, String languageId) {
        this._jsonObject = jsonObject;
        this._ddmForm = new DDMForm();
        this._ddmFormLayout = new DDMFormLayout();
        this._ddmFormValues = new DDMFormValues(this._ddmForm);
        this._locale = LocaleUtil.fromLanguageId((String)languageId);
        this.initModels();
        this.process();
    }

    public DDMForm getDDMForm() {
        return this._ddmForm;
    }

    public DDMFormLayout getDDMFormLayout() {
        return this._ddmFormLayout;
    }

    public DDMFormValues getDDMFormValues() {
        return this._ddmFormValues;
    }

    public long getGroupId() {
        return this._groupId;
    }

    protected void addDDMFormDDMFormField(JSONObject jsonObject) {
        String fieldName;
        Map ddmFormFields = this._ddmForm.getDDMFormFieldsMap(true);
        if (ddmFormFields.containsKey(fieldName = jsonObject.getString("fieldName"))) {
            return;
        }
        DDMFormField ddmFormField = this.getDDMFormField(jsonObject);
        this._ddmForm.addDDMFormField(ddmFormField);
    }

    protected void addDDMFormValuesDDMFormFieldValue(JSONObject jsonObject) {
        DDMFormFieldValue ddmFormFieldValue = this.getDDMFormFieldValue(jsonObject);
        this._ddmFormValues.addDDMFormFieldValue(ddmFormFieldValue);
    }

    protected DDMFormField getDDMFormField(JSONObject jsonObject) {
        String name = jsonObject.getString("fieldName");
        String type = jsonObject.getString("type");
        DDMFormField ddmFormField = new DDMFormField(name, type);
        this.setDDMFormFieldDataProviderSettings(jsonObject.getLong("ddmDataProviderInstanceId"), jsonObject.getString("ddmDataProviderInstanceOutput"), ddmFormField);
        this.setDDMFormFieldDataType(jsonObject.getString("dataType"), ddmFormField);
        this.setDDMFormFieldFieldName(jsonObject.getString("fieldName"), ddmFormField);
        this.setDDMFormFieldLabel(jsonObject.getString("label"), ddmFormField);
        this.setDDMFormFieldLocalizable(jsonObject.getBoolean("localizable", false), ddmFormField);
        this.setDDMFormFieldMultiple(jsonObject.getBoolean("multiple"), ddmFormField);
        this.setDDMFormFieldOptions(jsonObject.getJSONArray("options"), ddmFormField);
        this.setDDMFormFieldOptionsProperty(jsonObject, ddmFormField, "columns");
        this.setDDMFormFieldOptionsProperty(jsonObject, ddmFormField, "rows");
        this.setDDMFormFieldPlaceholder(jsonObject.getString("placeholder"), ddmFormField);
        this.setDDMFormFieldReadOnly(jsonObject.getBoolean("readOnly", false), ddmFormField);
        this.setDDMFormFieldRepeatable(jsonObject.getBoolean("repeatable", false), ddmFormField);
        this.setDDMFormFieldRequired(jsonObject.getBoolean("required", false), ddmFormField);
        this.setDDMFormFieldShowAsSwitcher(jsonObject.getBoolean("showAsSwitcher"), ddmFormField);
        this.setDDMFormFieldTooltip(jsonObject.getString("tooltip"), ddmFormField);
        this.setDDMFormFieldValid(jsonObject.getBoolean("valid", true), ddmFormField);
        this.setDDMFormFieldValidation(jsonObject.getJSONObject("validation"), ddmFormField);
        this.setDDMFormFieldVisibilityExpression(jsonObject.getString("visibilityExpression"), ddmFormField);
        this.setDDMFormFieldNestedFields(jsonObject.getJSONArray("nestedFields"), ddmFormField);
        return ddmFormField;
    }

    protected DDMFormFieldOptions getDDMFormFieldOptions(JSONArray jsonArray) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String value = jsonObject.getString("value");
            String label = jsonObject.getString("label");
            ddmFormFieldOptions.addOptionLabel(value, this._locale, label);
        }
        return ddmFormFieldOptions;
    }

    protected DDMFormFieldValue getDDMFormFieldValue(JSONObject jsonObject) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue();
        ddmFormFieldValue.setName(jsonObject.getString("fieldName"));
        ddmFormFieldValue.setInstanceId(jsonObject.getString("instanceId"));
        this.setDDMFormFieldValueValue(jsonObject.getString("value"), jsonObject.getBoolean("localizable", false), ddmFormFieldValue);
        this.setDDMFormFieldValueNestedFieldValues(jsonObject.getJSONArray("nestedFields"), ddmFormFieldValue);
        return ddmFormFieldValue;
    }

    protected DDMFormRule getDDMFormRule(JSONObject jsonObject) {
        List<String> actions = this.getDDMFormRuleActions(jsonObject.getJSONArray("actions"));
        return new DDMFormRule(jsonObject.getString("condition"), actions);
    }

    protected List<String> getDDMFormRuleActions(JSONArray jsonArray) {
        ArrayList<String> actions = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            actions.add(jsonArray.getString(i));
        }
        return actions;
    }

    protected List<DDMFormRule> getDDMFormRules(JSONArray jsonArray) {
        ArrayList<DDMFormRule> ddmFormRules = new ArrayList<DDMFormRule>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormRule ddmFormRule = this.getDDMFormRule(jsonArray.getJSONObject(i));
            ddmFormRules.add(ddmFormRule);
        }
        return ddmFormRules;
    }

    protected LocalizedValue getLocalizedValue(String value) {
        LocalizedValue localizedValue = new LocalizedValue(this._locale);
        localizedValue.addString(this._locale, value);
        return localizedValue;
    }

    protected void initModels() {
        this.setDDMFormRules();
        this.setDDMFormDefaultLocale();
        this.setDDMFormValuesDefaultLocale();
        this.setDDMFormValuesAvailableLocales();
        this.setGroupId();
    }

    protected void process() {
        this.traversePages(this._jsonObject.getJSONArray("pages"));
    }

    protected void setDDMFormDefaultLocale() {
        this._ddmForm.setDefaultLocale(this._locale);
    }

    protected void setDDMFormFieldDataProviderSettings(long ddmDataProviderInstanceId, String ddmDataProviderInstanceOutput, DDMFormField ddmFormField) {
        ddmFormField.setProperty("ddmDataProviderInstanceId", (Object)ddmDataProviderInstanceId);
        ddmFormField.setProperty("ddmDataProviderInstanceOutput", (Object)ddmDataProviderInstanceOutput);
    }

    protected void setDDMFormFieldDataType(String dataType, DDMFormField ddmFormField) {
        ddmFormField.setDataType(GetterUtil.getString((String)dataType));
    }

    protected void setDDMFormFieldFieldName(String fieldName, DDMFormField ddmFormField) {
        ddmFormField.setName(GetterUtil.getString((String)fieldName));
    }

    protected void setDDMFormFieldLabel(String label, DDMFormField ddmFormField) {
        ddmFormField.setLabel(this.getLocalizedValue(GetterUtil.getString((String)label)));
    }

    protected void setDDMFormFieldLocalizable(boolean localizable, DDMFormField ddmFormField) {
        ddmFormField.setLocalizable(localizable);
    }

    protected void setDDMFormFieldMultiple(boolean multiple, DDMFormField ddmFormField) {
        ddmFormField.setMultiple(multiple);
    }

    protected void setDDMFormFieldNestedFields(JSONArray jsonArray, DDMFormField ddmFormField) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormField nestedDDMFormField = this.getDDMFormField(jsonArray.getJSONObject(i));
            ddmFormField.addNestedDDMFormField(nestedDDMFormField);
        }
    }

    protected void setDDMFormFieldOptions(JSONArray jsonArray, DDMFormField ddmFormField) {
        if (jsonArray == null) {
            return;
        }
        DDMFormFieldOptions ddmFormFieldOptions = this.getDDMFormFieldOptions(jsonArray);
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
    }

    protected void setDDMFormFieldOptionsProperty(JSONObject jsonObject, DDMFormField ddmFormField, String property) {
        JSONArray jsonArray = jsonObject.getJSONArray(property);
        if (jsonArray == null) {
            return;
        }
        DDMFormFieldOptions ddmFormFieldOptions = this.getDDMFormFieldOptions(jsonArray);
        ddmFormField.setProperty(property, (Object)ddmFormFieldOptions);
    }

    protected void setDDMFormFieldPlaceholder(String placeholder, DDMFormField ddmFormField) {
        ddmFormField.setProperty("placeholder", (Object)this.getLocalizedValue(GetterUtil.getString((String)placeholder)));
    }

    protected void setDDMFormFieldReadOnly(boolean readOnly, DDMFormField ddmFormField) {
        ddmFormField.setReadOnly(readOnly);
    }

    protected void setDDMFormFieldRepeatable(boolean repeatable, DDMFormField ddmFormField) {
        ddmFormField.setRepeatable(repeatable);
    }

    protected void setDDMFormFieldRequired(boolean required, DDMFormField ddmFormField) {
        ddmFormField.setRequired(required);
    }

    protected void setDDMFormFieldShowAsSwitcher(boolean showAsSwitcher, DDMFormField ddmFormField) {
        ddmFormField.setProperty("showAsSwitcher", (Object)showAsSwitcher);
    }

    protected void setDDMFormFieldTooltip(String tooltip, DDMFormField ddmFormField) {
        ddmFormField.setProperty("tooltip", (Object)this.getLocalizedValue(GetterUtil.getString((String)tooltip)));
    }

    protected void setDDMFormFieldValid(boolean valid, DDMFormField ddmFormField) {
        ddmFormField.setProperty("valid", (Object)valid);
    }

    protected void setDDMFormFieldValidation(JSONObject jsonObject, DDMFormField ddmFormField) {
        if (jsonObject == null) {
            return;
        }
        DDMFormFieldValidation ddmFormFieldValidation = new DDMFormFieldValidation();
        ddmFormFieldValidation.setErrorMessage(jsonObject.getString("errorMessage"));
        ddmFormFieldValidation.setExpression(jsonObject.getString("expression"));
        ddmFormField.setDDMFormFieldValidation(ddmFormFieldValidation);
    }

    protected void setDDMFormFieldValueNestedFieldValues(JSONArray jsonArray, DDMFormFieldValue ddmFormFieldValue) {
        if (jsonArray == null) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            DDMFormFieldValue nestedDDMFormFieldValue = this.getDDMFormFieldValue(jsonArray.getJSONObject(i));
            ddmFormFieldValue.addNestedDDMFormFieldValue(nestedDDMFormFieldValue);
        }
    }

    protected void setDDMFormFieldValueValue(String value, boolean localizable, DDMFormFieldValue ddmFormFieldValue) {
        if (localizable) {
            LocalizedValue localizedValue = this.getLocalizedValue(value);
            ddmFormFieldValue.setValue((Value)localizedValue);
        } else {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(value));
        }
    }

    protected void setDDMFormFieldVisibilityExpression(String visibilityExpression, DDMFormField ddmFormField) {
        ddmFormField.setVisibilityExpression(GetterUtil.getString((String)visibilityExpression));
    }

    protected void setDDMFormRules() {
        List<DDMFormRule> ddmFormRules = this.getDDMFormRules(this._jsonObject.getJSONArray("rules"));
        this._ddmForm.setDDMFormRules(ddmFormRules);
    }

    protected void setDDMFormValuesAvailableLocales() {
        this._ddmFormValues.addAvailableLocale(this._locale);
    }

    protected void setDDMFormValuesDefaultLocale() {
        this._ddmFormValues.setDefaultLocale(this._locale);
    }

    protected void setGroupId() {
        this._groupId = this._jsonObject.getLong("groupId", 0L);
    }

    protected void traverseColumns(JSONArray jsonArray, DDMFormLayoutRow ddmFormLayoutRow) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutColumn ddmFormLayoutColumn = new DDMFormLayoutColumn(jsonObject.getInt("size"), new String[0]);
            this.traverseFields(jsonObject.getJSONArray("fields"), ddmFormLayoutColumn);
            ddmFormLayoutRow.addDDMFormLayoutColumn(ddmFormLayoutColumn);
        }
    }

    protected void traverseFields(JSONArray jsonArray, DDMFormLayoutColumn ddmFormLayoutColumn) {
        LinkedHashSet<String> ddmFormFieldNames = new LinkedHashSet<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this.addDDMFormDDMFormField(jsonObject);
            this.addDDMFormValuesDDMFormFieldValue(jsonObject);
            ddmFormFieldNames.add(jsonObject.getString("fieldName"));
        }
        ddmFormLayoutColumn.setDDMFormFieldNames(ListUtil.fromCollection(ddmFormFieldNames));
    }

    protected void traversePages(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutPage ddmFormLayoutPage = new DDMFormLayoutPage();
            this.traverseRows(jsonObject.getJSONArray("rows"), ddmFormLayoutPage);
            this._ddmFormLayout.addDDMFormLayoutPage(ddmFormLayoutPage);
        }
    }

    protected void traverseRows(JSONArray jsonArray, DDMFormLayoutPage ddmFormLayoutPage) {
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            DDMFormLayoutRow ddmFormLayoutRow = new DDMFormLayoutRow();
            this.traverseColumns(jsonObject.getJSONArray("columns"), ddmFormLayoutRow);
            ddmFormLayoutPage.addDDMFormLayoutRow(ddmFormLayoutRow);
        }
    }
}

