/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.renderer.internal;

import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class DDMFormTemplateContextFactoryHelper {
    private static final Log _log = LogFactoryUtil.getLog(DDMFormTemplateContextFactoryHelper.class);
    private static final Pattern _callFunctionPattern = Pattern.compile("call\\(\\s*'([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})'\\s*,\\s*'(.*)'\\s*,\\s*'(.*)'\\s*\\)");
    private final DDMDataProviderInstanceService _ddmDataProviderInstanceService;

    public DDMFormTemplateContextFactoryHelper(DDMDataProviderInstanceService ddmDataProviderInstanceService) {
        this._ddmDataProviderInstanceService = ddmDataProviderInstanceService;
    }

    public Map<String, Map<String, Object>> getDataProviderSettings(DDMForm ddmForm) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        this.extractDataProviderSettingsFromFieldSettings(ddmForm, map);
        this.extractDataProviderSettingsFromAutoFillActions(ddmForm, map);
        return map;
    }

    public Set<String> getEvaluableDDMFormFieldNames(DDMForm ddmForm) {
        HashSet<String> evaluableDDMFormFieldNames = new HashSet<String>();
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Set<String> ddmFormFieldNames = ddmFormFieldsMap.keySet();
        evaluableDDMFormFieldNames.addAll(this.getReferencedFieldNamesByDDMFormRules(ddmForm.getDDMFormRules(), ddmFormFieldNames));
        for (DDMFormField ddmFormField : ddmFormFieldsMap.values()) {
            if (this.isDDMFormFieldEvaluable(ddmFormField)) {
                evaluableDDMFormFieldNames.add(ddmFormField.getName());
            }
            String visibilityExpression = ddmFormField.getVisibilityExpression();
            evaluableDDMFormFieldNames.addAll(this.getReferencedFieldNamesByExpression(visibilityExpression, ddmFormFieldNames));
        }
        return evaluableDDMFormFieldNames;
    }

    protected Map<String, Object> createDataProviderSettingsMap(String dataProviderInstanceUUID, String outputParameterName, Map<String, String> inputParameters) {
        HashMap<String, Object> ddmDataProviderSettingsMap = new HashMap<String, Object>();
        ddmDataProviderSettingsMap.put("dataProviderInstanceUUID", dataProviderInstanceUUID);
        ddmDataProviderSettingsMap.put("inputParameters", inputParameters);
        ddmDataProviderSettingsMap.put("outputParameterName", outputParameterName);
        return ddmDataProviderSettingsMap;
    }

    protected Map<String, String> extractAutoFillParameters(String expression) {
        if (Validator.isNull((String)expression)) {
            return Collections.emptyMap();
        }
        String[] innerExpressions = StringUtil.split((String)expression, (char)';');
        HashMap<String, String> map = new HashMap<String, String>();
        Stream.of(innerExpressions).forEach(innerExpression -> {
            String[] parts = StringUtil.split((String)innerExpression, (char)'=');
            map.put(parts[0], parts[1]);
        });
        return map;
    }

    protected void extractDataProviderSettings(DDMFormField ddmFormField, Map<String, Map<String, Object>> dataProviderSettings) {
        block3: {
            long ddmDataProviderInstanceId = MapUtil.getLong((Map)ddmFormField.getProperties(), (String)"ddmDataProviderInstanceId");
            if (ddmDataProviderInstanceId == 0L) {
                return;
            }
            try {
                DDMDataProviderInstance ddmDataProviderInstance = this._ddmDataProviderInstanceService.getDataProviderInstance(ddmDataProviderInstanceId);
                String ddmDataProviderInstanceOutput = GetterUtil.getString((Object)ddmFormField.getProperty("ddmDataProviderInstanceOutput"));
                dataProviderSettings.put(ddmFormField.getName(), this.createDataProviderSettingsMap(ddmDataProviderInstance.getUuid(), ddmDataProviderInstanceOutput, Collections.emptyMap()));
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
    }

    protected void extractDataProviderSettings(String action, Map<String, DDMFormField> ddmFormFields, Map<String, Map<String, Object>> dataProviderSettings) {
        Matcher matcher = _callFunctionPattern.matcher(action);
        if (matcher.find()) {
            String dataProviderInstanceUUID = matcher.group(1);
            Map<String, String> inputParameters = this.extractAutoFillParameters(matcher.group(2));
            Map<String, String> outputParameters = this.extractAutoFillParameters(matcher.group(3));
            Set<Map.Entry<String, String>> entrySet = outputParameters.entrySet();
            Stream<Object> outputParametersStream = entrySet.stream();
            outputParametersStream = outputParametersStream.filter(entry -> this.isSelectField((DDMFormField)ddmFormFields.get(entry.getKey())));
            outputParametersStream.forEach(entry -> dataProviderSettings.put((String)entry.getKey(), this.createDataProviderSettingsMap(dataProviderInstanceUUID, (String)entry.getValue(), inputParameters)));
        }
    }

    protected void extractDataProviderSettingsFromAutoFillActions(DDMForm ddmForm, Map<String, Map<String, Object>> dataProviderSettings) {
        List ddmFormRules = ddmForm.getDDMFormRules();
        Map ddmFormFields = ddmForm.getDDMFormFieldsMap(true);
        Stream ddmFormRulesStream = ddmFormRules.stream();
        Stream actionsStream = ddmFormRulesStream.flatMap(ddmFormRule -> {
            List actions = ddmFormRule.getActions();
            return actions.stream();
        });
        actionsStream.filter(this::isAutofillAction).forEach(action -> this.extractDataProviderSettings((String)action, ddmFormFields, dataProviderSettings));
    }

    protected void extractDataProviderSettingsFromFieldSettings(DDMForm ddmForm, Map<String, Map<String, Object>> dataProviderSettings) {
        Map ddmFormFields = ddmForm.getDDMFormFieldsMap(true);
        Collection ddmFormFieldsCollection = ddmFormFields.values();
        Stream ddmFormFieldsStream = ddmFormFieldsCollection.stream();
        ddmFormFieldsStream.filter(this::hasDataProviderSettings).forEach(ddmFormField -> this.extractDataProviderSettings((DDMFormField)ddmFormField, dataProviderSettings));
    }

    protected Set<String> getReferencedFieldNamesByDDMFormRules(List<DDMFormRule> ddmFormRules, Set<String> ddmFormFieldNames) {
        HashSet<String> referencedFieldNames = new HashSet<String>();
        for (DDMFormRule ddmFormRule : ddmFormRules) {
            String condition = ddmFormRule.getCondition();
            referencedFieldNames.addAll(this.getReferencedFieldNamesByExpression(condition, ddmFormFieldNames));
            for (String action : ddmFormRule.getActions()) {
                referencedFieldNames.addAll(this.getReferencedFieldNamesByExpression(action, ddmFormFieldNames));
            }
        }
        return referencedFieldNames;
    }

    protected Set<String> getReferencedFieldNamesByExpression(String expression, Set<String> ddmFormFieldNames) {
        if (Validator.isNull((String)expression)) {
            return Collections.emptySet();
        }
        HashSet<String> referencedFieldNames = new HashSet<String>();
        for (String ddmFormFieldName : ddmFormFieldNames) {
            if (!expression.contains(ddmFormFieldName)) continue;
            referencedFieldNames.add(ddmFormFieldName);
        }
        return referencedFieldNames;
    }

    protected boolean hasDataProviderSettings(DDMFormField ddmFormField) {
        return MapUtil.getLong((Map)ddmFormField.getProperties(), (String)"ddmDataProviderInstanceId") > 0L;
    }

    protected boolean isAutofillAction(String action) {
        Matcher matcher = _callFunctionPattern.matcher(action);
        return matcher.matches();
    }

    protected boolean isDDMFormFieldEvaluable(DDMFormField ddmFormField) {
        if (ddmFormField.isRequired()) {
            return true;
        }
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        return ddmFormFieldValidation != null && Validator.isNotNull((String)ddmFormFieldValidation.getExpression());
    }

    protected boolean isSelectField(DDMFormField ddmFormField) {
        if (ddmFormField == null) {
            return false;
        }
        String type = ddmFormField.getType();
        return type.equals("select");
    }
}

