/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.helper;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormEvaluatorFieldContextKey;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DDMFormEvaluatorFormValuesHelper {
    private final Map<String, Map<DDMFormEvaluatorFieldContextKey, DDMFormFieldValue>> _ddmFormFieldValuesMap = new HashMap<String, Map<DDMFormEvaluatorFieldContextKey, DDMFormFieldValue>>();

    public DDMFormEvaluatorFormValuesHelper(DDMFormValues ddmFormValues) {
        this._createDDMFormFieldValuesMap(ddmFormValues);
    }

    public Set<DDMFormEvaluatorFieldContextKey> getDDMFormFieldContextKeys(String fieldName) {
        Map map = this._ddmFormFieldValuesMap.getOrDefault(fieldName, Collections.emptyMap());
        return map.keySet();
    }

    public DDMFormFieldValue getDDMFormFieldValue(DDMFormEvaluatorFieldContextKey fieldContextKey) {
        Map map = this._ddmFormFieldValuesMap.getOrDefault(fieldContextKey.getName(), Collections.emptyMap());
        return (DDMFormFieldValue)map.get(fieldContextKey);
    }

    private void _createDDMFormFieldValuesMap(DDMFormValues ddmFormValues) {
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this._populateDDMFormFieldValues(ddmFormFieldValue);
        }
    }

    private void _populateDDMFormFieldValues(DDMFormFieldValue ddmFormFieldValue) {
        Map<DDMFormEvaluatorFieldContextKey, DDMFormFieldValue> ddmFormFieldValuesMap = this._ddmFormFieldValuesMap.get(ddmFormFieldValue.getName());
        if (ddmFormFieldValuesMap == null) {
            ddmFormFieldValuesMap = new HashMap<DDMFormEvaluatorFieldContextKey, DDMFormFieldValue>();
            this._ddmFormFieldValuesMap.put(ddmFormFieldValue.getName(), ddmFormFieldValuesMap);
        }
        ddmFormFieldValuesMap.put(new DDMFormEvaluatorFieldContextKey(ddmFormFieldValue.getName(), ddmFormFieldValue.getInstanceId()), ddmFormFieldValue);
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this._populateDDMFormFieldValues(nestedDDMFormFieldValue);
        }
    }
}

