/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.function;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInvoker;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFieldAccessorAware;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserver;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionObserverAware;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyRequest;
import com.liferay.dynamic.data.mapping.expression.GetFieldPropertyResponse;
import com.liferay.dynamic.data.mapping.expression.UpdateFieldPropertyRequest;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CallFunction
implements DDMExpressionFieldAccessorAware,
DDMExpressionFunction.Function3<String, String, String, Boolean>,
DDMExpressionObserverAware {
    public static final String NAME = "call";
    protected DDMDataProviderInvoker ddmDataProviderInvoker;
    protected JSONFactory jsonFactory;
    private static final Log _log = LogFactoryUtil.getLog(CallFunction.class);
    private DDMExpressionFieldAccessor _ddmExpressionFieldAccessor;
    private DDMExpressionObserver _ddmExpressionObserver;

    public CallFunction(DDMDataProviderInvoker ddmDataProviderInvoker, JSONFactory jsonFactory) {
        this.ddmDataProviderInvoker = ddmDataProviderInvoker;
        this.jsonFactory = jsonFactory;
    }

    public Boolean apply(String ddmDataProviderInstanceUUID, String paramsExpression, String resultMapExpression) {
        block5: {
            if (this._ddmExpressionFieldAccessor == null) {
                return false;
            }
            try {
                DDMDataProviderRequest.Builder builder = DDMDataProviderRequest.Builder.newBuilder();
                builder = builder.withDDMDataProviderId(ddmDataProviderInstanceUUID);
                Map<String, String> parameterMap = this._extractParameters(paramsExpression);
                for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
                    if (Objects.equals(entry.getKey(), "locale")) {
                        builder = builder.withLocale(LocaleUtil.fromLanguageId((String)entry.getValue()));
                        continue;
                    }
                    builder = builder.withParameter(entry.getKey(), (Object)entry.getValue());
                }
                DDMDataProviderRequest ddmDataProviderRequest = builder.build();
                DDMDataProviderResponse ddmDataProviderResponse = this.ddmDataProviderInvoker.invoke(ddmDataProviderRequest);
                Map<String, String> resultMap = this._extractResults(resultMapExpression);
                this.setDDMFormFieldValues(ddmDataProviderResponse, resultMap);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)exception);
            }
        }
        return true;
    }

    public String getName() {
        return NAME;
    }

    public void setDDMExpressionFieldAccessor(DDMExpressionFieldAccessor ddmExpressionFieldAccessor) {
        this._ddmExpressionFieldAccessor = ddmExpressionFieldAccessor;
    }

    public void setDDMExpressionObserver(DDMExpressionObserver ddmExpressionObserver) {
        this._ddmExpressionObserver = ddmExpressionObserver;
    }

    protected String getDDMFormFieldValue(String ddmFormFieldName) {
        Object[] valueArray;
        GetFieldPropertyRequest.Builder builder = GetFieldPropertyRequest.Builder.newBuilder((String)ddmFormFieldName, (String)"value");
        GetFieldPropertyResponse getFieldPropertyResponse = this._ddmExpressionFieldAccessor.getFieldProperty(builder.build());
        Object value = getFieldPropertyResponse.getValue();
        if (Validator.isNull((Object)value)) {
            return "";
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray() && ArrayUtil.isNotEmpty((Object[])(valueArray = (Object[])value))) {
            value = ((Object[])value)[0];
        }
        try {
            JSONArray jsonArray = this.jsonFactory.createJSONArray(String.valueOf(value));
            return (String)jsonArray.get(0);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return String.valueOf(value);
        }
    }

    protected void setDDMFormFieldOptions(String field, List<KeyValuePair> options) {
        UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)field, (String)"options", options);
        this._ddmExpressionObserver.updateFieldProperty(builder.build());
    }

    protected void setDDMFormFieldValues(DDMDataProviderResponse ddmDataProviderResponse, Map<String, String> resultMap) {
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            String outputName = entry.getValue();
            String ddmFormFieldName = entry.getKey();
            if (!ddmDataProviderResponse.hasOutput(outputName)) {
                this.setDDMFormFieldOptions(ddmFormFieldName, Collections.emptyList());
                continue;
            }
            Optional optionsOptional = ddmDataProviderResponse.getOutputOptional(outputName, List.class);
            if (optionsOptional.isPresent()) {
                this.setDDMFormFieldOptions(ddmFormFieldName, (List)optionsOptional.get());
                continue;
            }
            Optional<Object> valueOptional = ddmDataProviderResponse.getOutputOptional(outputName, String.class);
            if (!valueOptional.isPresent()) {
                valueOptional = ddmDataProviderResponse.getOutputOptional(outputName, Number.class);
                valueOptional = valueOptional.map(value -> new BigDecimal(value.toString()));
            }
            this._setDDMFormFieldValue(ddmFormFieldName, valueOptional.get());
        }
    }

    private void _extractDDMFormFieldValue(String expression, Map<String, String> parameters) {
        String[] tokens = StringUtil.split((String)expression, (char)'=');
        String parameterName = tokens[0];
        String parameterValue = "";
        if (tokens.length == 2) {
            parameterValue = tokens[1];
        }
        if (this._ddmExpressionFieldAccessor.isField(parameterValue)) {
            parameterValue = this.getDDMFormFieldValue(parameterValue);
        }
        parameters.put(parameterName, parameterValue);
    }

    private Map<String, String> _extractParameters(String expression) {
        if (Validator.isNull((String)expression)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        String[] innerExpressions = StringUtil.split((String)expression, (char)';');
        if (innerExpressions.length == 0) {
            this._extractDDMFormFieldValue(expression, parameters);
        } else {
            for (String innerExpression : innerExpressions) {
                this._extractDDMFormFieldValue(innerExpression, parameters);
            }
        }
        return parameters;
    }

    private Map<String, String> _extractResults(String resultMapExpression) {
        String[] innerExpressions;
        if (Validator.isNull((String)resultMapExpression)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>();
        for (String innerExpression : innerExpressions = StringUtil.split((String)resultMapExpression, (char)';')) {
            String[] tokens = StringUtil.split((String)innerExpression, (char)'=');
            results.put(tokens[0], tokens[1]);
        }
        return results;
    }

    private void _setDDMFormFieldValue(String field, Object value) {
        UpdateFieldPropertyRequest.Builder builder = UpdateFieldPropertyRequest.Builder.newBuilder((String)field, (String)"value", (Object)value);
        this._ddmExpressionObserver.updateFieldProperty(builder.build());
    }
}

