/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.function;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessor;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionParameterAccessorAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(factory="com.liferay.dynamic.data.mapping.expression.DDMExpressionFunctionFactory", service={DDMExpressionFunction.Function1.class, DDMExpressionParameterAccessorAware.class})
public class BelongsToRoleFunction
implements DDMExpressionFunction.Function1<String[], Boolean>,
DDMExpressionParameterAccessorAware {
    @Reference
    protected RoleLocalService roleLocalService;
    @Reference
    protected UserGroupRoleLocalService userGroupRoleLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BelongsToRoleFunction.class);
    private DDMExpressionParameterAccessor _ddmExpressionParameterAccessor;

    public Boolean apply(String[] roles) {
        block4: {
            if (this._ddmExpressionParameterAccessor == null) {
                return false;
            }
            try {
                long companyId = this._ddmExpressionParameterAccessor.getCompanyId();
                long groupId = this._ddmExpressionParameterAccessor.getGroupId();
                long userId = this._ddmExpressionParameterAccessor.getUserId();
                for (String roleName : roles) {
                    boolean belongsTo;
                    Role role = this.roleLocalService.fetchRole(companyId, roleName);
                    if (role == null || !(userId == 0L ? roleName.equals("Guest") : (belongsTo = role.getType() == 1 ? this.userLocalService.hasRoleUser(companyId, roleName, userId, true) : this.userGroupRoleLocalService.hasUserGroupRole(userId, groupId, roleName, true)))) continue;
                    return true;
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return false;
    }

    public String getName() {
        return "belongsTo";
    }

    public void setDDMExpressionParameterAccessor(DDMExpressionParameterAccessor ddmExpressionParameterAccessor) {
        this._ddmExpressionParameterAccessor = ddmExpressionParameterAccessor;
    }
}

