/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.functions;

import com.liferay.dynamic.data.mapping.form.evaluator.DDMFormFieldEvaluationResult;
import com.liferay.dynamic.data.mapping.form.evaluator.internal.functions.BaseDDMFormRuleFunction;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SetOptionsFunction
extends BaseDDMFormRuleFunction {
    private static Log _log = LogFactoryUtil.getLog(SetOptionsFunction.class);
    private final JSONFactory _jsonFactory;
    private final String _languageId;

    public SetOptionsFunction(Map<String, List<DDMFormFieldEvaluationResult>> ddmFormFieldEvaluationResults, Locale locale, JSONFactory jsonFactory) {
        super(ddmFormFieldEvaluationResults);
        this._languageId = LanguageUtil.getLanguageId((Locale)locale);
        this._jsonFactory = jsonFactory;
    }

    public Object evaluate(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Two parameters are expected");
        }
        List<KeyValuePair> keyValuePairs = this.createKeyValuePairList(String.valueOf(parameters[1]));
        List<DDMFormFieldEvaluationResult> ddmFormFieldEvaluationResults = this.getDDMFormFieldEvaluationResults(String.valueOf(parameters[0]));
        for (DDMFormFieldEvaluationResult ddmFormFieldEvaluationResult : ddmFormFieldEvaluationResults) {
            ddmFormFieldEvaluationResult.setProperty("options", keyValuePairs);
        }
        return true;
    }

    protected List<KeyValuePair> createKeyValuePairList(String value) {
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(String.valueOf(value));
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String languageId = (String)keys.next();
                if (!languageId.equals(this._languageId)) continue;
                JSONArray jsonArray = jsonObject.getJSONArray(languageId);
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject optionJSONObject = jsonArray.getJSONObject(i);
                    KeyValuePair keyValuePair = new KeyValuePair(optionJSONObject.getString("value"), optionJSONObject.getString("label"));
                    keyValuePairs.add(keyValuePair);
                }
                break;
            }
        }
        catch (JSONException jsone) {
            _log.error((Object)jsone, (Throwable)jsone);
        }
        return keyValuePairs;
    }
}

