/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.evaluator.internal.functions;

import com.liferay.dynamic.data.mapping.expression.DDMExpressionFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;

public class BelongsToRoleFunction
implements DDMExpressionFunction {
    private static final Log _log = LogFactoryUtil.getLog(BelongsToRoleFunction.class);
    private final long _groupId;
    private final HttpServletRequest _request;
    private final RoleLocalService _roleLocalService;
    private final UserGroupRoleLocalService _userGroupRoleLocalService;
    private final UserLocalService _userLocalService;

    public BelongsToRoleFunction(HttpServletRequest request, long groupId, RoleLocalService roleLocalService, UserGroupRoleLocalService userGroupRoleLocalService, UserLocalService userLocalService) {
        this._request = request;
        this._groupId = groupId;
        this._roleLocalService = roleLocalService;
        this._userGroupRoleLocalService = userGroupRoleLocalService;
        this._userLocalService = userLocalService;
    }

    public Object evaluate(Object ... parameters) {
        block4: {
            if (parameters.length < 1) {
                throw new IllegalArgumentException("At least one parameter is expected");
            }
            try {
                Company company = PortalUtil.getCompany((HttpServletRequest)this._request);
                User user = PortalUtil.getUser((HttpServletRequest)this._request);
                for (Object parameter : parameters) {
                    boolean belongsTo;
                    String roleName = String.valueOf(parameter);
                    Role role = this._roleLocalService.fetchRole(company.getCompanyId(), roleName);
                    if (role == null || !(user == null ? parameter.equals("Guest") : (belongsTo = role.getType() == 1 ? this._userLocalService.hasRoleUser(company.getCompanyId(), roleName, user.getUserId(), true) : this._userGroupRoleLocalService.hasUserGroupRole(user.getUserId(), this._groupId, roleName, true)))) continue;
                    return true;
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return false;
    }
}

