Liferay.Loader.define("dynamic-data-mapping-form-builder@3.0.50/js/components/LayoutProvider/util/fieldset.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer', '../../../util/constants.es', '../../../util/fieldSupport.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.createFieldSet = void 0;

    var _dynamicDataMappingFormRenderer = require("dynamic-data-mapping-form-renderer");

    var _constants = require("../../../util/constants.es");

    var _fieldSupport = require("../../../util/fieldSupport.es");

    var _settingsContext = require("../util/settingsContext.es");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    var addNestedFields = function addNestedFields(_ref) {
      var field = _ref.field,
          indexes = _ref.indexes,
          nestedFields = _ref.nestedFields,
          props = _ref.props;
      var layout = [{
        rows: field.rows
      }];
      var visitor = new _dynamicDataMappingFormRenderer.PagesVisitor(layout);
      visitor.mapFields(function (field, fieldIndex, columnIndex, rowIndex, pageIndex) {
        if (!nestedFields.some(function (nestedField) {
          return nestedField.fieldName === field.fieldName;
        })) {
          layout = _dynamicDataMappingFormRenderer.FormSupport.removeFields(layout, pageIndex, rowIndex, columnIndex);
        }
      });

      _toConsumableArray(nestedFields).reverse().forEach(function (nestedField) {
        if (!nestedField.instanceId) {
          nestedField.instanceId = (0, _fieldSupport.generateInstanceId)(8);
        }

        layout = _dynamicDataMappingFormRenderer.FormSupport.addFieldToColumn(layout, indexes.pageIndex, indexes.rowIndex, indexes.columnIndex, nestedField.fieldName);
      });

      field = (0, _settingsContext.updateField)(props, field, 'nestedFields', nestedFields);
      var rows = layout[indexes.pageIndex].rows;
      return _objectSpread({}, (0, _settingsContext.updateField)(props, field, 'rows', rows), {
        nestedFields: nestedFields,
        rows: rows
      });
    };

    var createFieldSet = function createFieldSet(props, event, nestedFields) {
      var rows = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [{
        columns: [{
          fields: [],
          size: 12
        }]
      }];
      var fieldTypes = props.fieldTypes;
      var fieldType = fieldTypes.find(function (fieldType) {
        return fieldType.name === _constants.FIELD_TYPE_FIELDSET;
      });
      var fieldSetField = (0, _fieldSupport.createField)(props, _objectSpread({}, event, {
        fieldType: fieldType
      }));
      return addNestedFields({
        field: _objectSpread({}, fieldSetField, {
          rows: rows
        }),
        indexes: {
          columnIndex: 0,
          pageIndex: 0,
          rowIndex: 0
        },
        nestedFields: nestedFields,
        props: props
      });
    };

    exports.createFieldSet = createFieldSet;
    //# sourceMappingURL=fieldset.es.js.map
  }
});
//# sourceMappingURL=fieldset.es.js.map