Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.86/js/components/LayoutProvider/util/rules.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', '../../../expressions/Token.es', '../../../expressions/Tokenizer.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateRulesReferences = exports.renameFieldInsideAutofill = exports.renameFieldInsideExpression = exports.isFieldValueOperand = void 0;

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _Token = _interopRequireDefault(require("../../../expressions/Token.es"));

  var _Tokenizer = _interopRequireDefault(require("../../../expressions/Tokenizer.es"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var isFieldValueOperand = function isFieldValueOperand(operands) {
    return operands.length == 2 && operands[0].type === 'field' && operands[1].type == 'string';
  };

  exports.isFieldValueOperand = isFieldValueOperand;

  var renameFieldInsideExpression = function renameFieldInsideExpression(expression, fieldName, newFieldName) {
    var tokens = _Tokenizer["default"].tokenize(expression);

    return _Tokenizer["default"].stringifyTokens(tokens.map(function (token) {
      if (token.type === _Token["default"].VARIABLE && token.value === fieldName) {
        token = new _Token["default"](_Token["default"].VARIABLE, newFieldName);
      }

      return token;
    }));
  };

  exports.renameFieldInsideExpression = renameFieldInsideExpression;

  var renameFieldInsideAutofill = function renameFieldInsideAutofill(object, oldFieldName, newFieldName) {
    Object.keys(object).map(function (key) {
      if (object[key] === oldFieldName) {
        object[key] = newFieldName;
      }
    });
    return object;
  };

  exports.renameFieldInsideAutofill = renameFieldInsideAutofill;

  var updateRulesReferences = function updateRulesReferences(newProperties, oldProperties, optionIndex, rules) {
    var oldFieldName = oldProperties.fieldName;
    var newFieldName = newProperties.fieldName;
    var visitor = new _visitors.RulesVisitor(rules);
    rules = visitor.mapActions(function (action) {
      if (action.target === oldFieldName) {
        action = _objectSpread({}, action, {
          target: newFieldName
        });
      }

      if (action.action === 'calculate') {
        action = _objectSpread({}, action, {
          expression: renameFieldInsideExpression(action.expression, oldFieldName, newFieldName)
        });
      } else if (action.action === 'auto-fill') {
        action = _objectSpread({}, action, {
          inputs: renameFieldInsideAutofill(action.inputs, oldFieldName, newFieldName),
          outputs: renameFieldInsideAutofill(action.outputs, oldFieldName, newFieldName)
        });
      }

      return action;
    });
    visitor.setRules(rules);
    return visitor.mapConditions(function (condition) {
      return _objectSpread({}, condition, {
        operands: condition.operands.map(function (operand, index) {
          var oldOptions = oldProperties.options;
          var newOptions = newProperties.options;

          if (operand.type === 'field' && operand.value === oldFieldName) {
            return _objectSpread({}, operand, {
              value: newFieldName
            });
          } else if (index === 1 && !isNaN(optionIndex) && optionIndex < oldOptions.length && isFieldValueOperand(condition.operands) && oldOptions[optionIndex].value == operand.value && newOptions[optionIndex].value != oldOptions[optionIndex].value) {
            return _objectSpread({}, operand, {
              value: newOptions[optionIndex].value
            });
          }

          return operand;
        })
      });
    });
  };

  exports.updateRulesReferences = updateRulesReferences;
  //# sourceMappingURL=rules.es.js.map
});
//# sourceMappingURL=rules.es.js.map