Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.86/js/components/LayoutProvider/handlers/fieldDeletedHandler.es", ['module', 'exports', 'require', 'dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es', 'dynamic-data-mapping-form-renderer/js/util/visitors.es', '../../RuleBuilder/RulesSupport.es', '../util/settingsContext.es'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = exports.handleFieldDeleted = exports.removeField = void 0;

  var FormSupport = _interopRequireWildcard(require("dynamic-data-mapping-form-renderer/js/components/FormRenderer/FormSupport.es"));

  var _visitors = require("dynamic-data-mapping-form-renderer/js/util/visitors.es");

  var _RulesSupport = _interopRequireDefault(require("../../RuleBuilder/RulesSupport.es"));

  var _settingsContext = require("../util/settingsContext.es");

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function ownKeys(object, enumerableOnly) {
    var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
      var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
        return Object.getOwnPropertyDescriptor(object, sym).enumerable;
      });keys.push.apply(keys, symbols);
    }return keys;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
        ownKeys(Object(source), true).forEach(function (key) {
          _defineProperty(target, key, source[key]);
        });
      } else if (Object.getOwnPropertyDescriptors) {
        Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
      } else {
        ownKeys(Object(source)).forEach(function (key) {
          Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
        });
      }
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var removeField = function removeField(props, pages, fieldName) {
    var visitor = new _visitors.PagesVisitor(pages);

    var filter = function filter(fields) {
      return fields.filter(function (field) {
        return field.fieldName !== fieldName;
      }).map(function (field) {
        var pages = [{
          rows: field.rows
        }];
        var visitor = new _visitors.PagesVisitor(pages);
        var nestedFields = field.nestedFields ? filter(field.nestedFields) : [];
        field = (0, _settingsContext.updateField)(props, field, 'nestedFields', nestedFields);
        var rows = field.rows ? FormSupport.removeEmptyRows(visitor.mapColumns(function (column) {
          return _objectSpread({}, column, {
            fields: column.fields.filter(function (nestedFieldName) {
              return fieldName !== nestedFieldName;
            })
          });
        }), 0) : [];
        field = (0, _settingsContext.updateField)(props, field, 'rows', rows);
        return _objectSpread({}, field, {
          nestedFields: nestedFields,
          rows: rows
        });
      });
    };

    return visitor.mapColumns(function (column) {
      return _objectSpread({}, column, {
        fields: filter(column.fields)
      });
    });
  };

  exports.removeField = removeField;

  var removeEmptyRow = function removeEmptyRow(pages, source) {
    var pageIndex = source.pageIndex,
        rowIndex = source.rowIndex;

    if (!FormSupport.rowHasFields(pages, pageIndex, rowIndex)) {
      pages = FormSupport.removeRow(pages, pageIndex, rowIndex);
    }

    return pages;
  };

  var handleFieldDeleted = function handleFieldDeleted(state, indexes) {
    var columnIndex = indexes.columnIndex,
        pageIndex = indexes.pageIndex,
        rowIndex = indexes.rowIndex;
    var pages = state.pages;
    var newContext = FormSupport.removeFields(pages, pageIndex, rowIndex, columnIndex);
    newContext = removeEmptyRow(newContext, {
      columnIndex: columnIndex,
      pageIndex: pageIndex,
      rowIndex: rowIndex
    });
    return {
      focusedField: {},
      pages: newContext,
      rules: _RulesSupport["default"].formatRules(newContext, state.rules)
    };
  };

  exports.handleFieldDeleted = handleFieldDeleted;
  var _default = handleFieldDeleted;
  exports["default"] = _default;
  //# sourceMappingURL=fieldDeletedHandler.es.js.map
});
//# sourceMappingURL=fieldDeletedHandler.es.js.map