"use strict";

Liferay.Loader.define("dynamic-data-mapping-form-builder@2.0.17/js/components/Form/FormSupport.es", ['module', 'exports', 'require', '../../util/visitors.es'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.updateColumn = exports.updateField = exports.getIndexes = exports.rowHasFields = exports.getRow = exports.getField = exports.getColumnPosition = exports.getColumn = exports.findFieldByName = exports.removeRow = exports.removeEmptyRows = exports.removeFields = exports.removeColumn = exports.setColumnFields = exports.emptyPages = exports.addFieldToColumn = exports.addColumn = exports.addRow = exports.implAddRow = exports.implAddColumn = void 0;

  var _visitors = require("../../util/visitors.es");

  function _toConsumableArray(arr) {
    return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
  }

  function _nonIterableSpread() {
    throw new TypeError("Invalid attempt to spread non-iterable instance");
  }

  function _iterableToArray(iter) {
    if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
  }

  function _arrayWithoutHoles(arr) {
    if (Array.isArray(arr)) {
      for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};var ownKeys = Object.keys(source);if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }return target;
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
    } else {
      obj[key] = value;
    }return obj;
  }

  var implAddColumn = function implAddColumn(size) {
    var fields = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    return {
      fields: fields,
      size: size
    };
  };

  exports.implAddColumn = implAddColumn;

  var implAddRow = function implAddRow(size, fields) {
    return {
      columns: [implAddColumn(size, fields)]
    };
  };

  exports.implAddRow = implAddRow;

  var addRow = function addRow(pages, indexToAddRow, pageIndex) {
    var newRow = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : implAddRow(12, []);
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapPages(function (page, currentPageIndex) {
      var newPage = page;

      if (pageIndex === currentPageIndex) {
        newPage = _objectSpread({}, page, {
          rows: [].concat(_toConsumableArray(page.rows.slice(0, indexToAddRow)), [newRow], _toConsumableArray(page.rows.slice(indexToAddRow)))
        });
      }

      return newPage;
    });
  };

  exports.addRow = addRow;

  var addColumn = function addColumn(pages, indexToAddColumn, pageIndex, rowIndex) {
    var newColumn = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : implAddColumn(11, []);
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapRows(function (row, currentRowIndex, currentPageIndex) {
      var newRow = row;

      if (currentRowIndex === rowIndex && currentPageIndex === pageIndex) {
        newRow = _objectSpread({}, row, {
          columns: [].concat(_toConsumableArray(row.columns.slice(0, indexToAddColumn)), [newColumn], _toConsumableArray(row.columns.slice(indexToAddColumn)))
        });
      }

      return newRow;
    });
  };

  exports.addColumn = addColumn;

  var addFieldToColumn = function addFieldToColumn(pages, pageIndex, rowIndex, columnIndex, field) {
    var numberOfRows = pages[pageIndex].rows.length;

    if (rowIndex >= numberOfRows) {
      pages = addRow(pages, numberOfRows, pageIndex);
    }

    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapColumns(function (column, currentColumnIndex, currentRowIndex, currentPageIndex) {
      var newColumn = column;

      if (currentColumnIndex === columnIndex && currentRowIndex === rowIndex && currentPageIndex === pageIndex) {
        newColumn = _objectSpread({}, column, {
          fields: [].concat(_toConsumableArray(column.fields), [field])
        });
      }

      return newColumn;
    });
  };

  exports.addFieldToColumn = addFieldToColumn;

  var emptyPages = function emptyPages(pages) {
    var empty = true;
    var visitor = new _visitors.PagesVisitor(pages);
    visitor.mapFields(function () {
      empty = false;
    });
    return empty;
  };

  exports.emptyPages = emptyPages;

  var setColumnFields = function setColumnFields(pages, pageIndex, rowIndex, columnIndex) {
    var fields = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [];
    var numberOfRows = pages[Number(pageIndex)].rows.length;

    if (numberOfRows - 1 < rowIndex) {
      pages = addRow(pages, rowIndex, pageIndex);
      pages = addFieldToColumn(pages, pageIndex, rowIndex, columnIndex, fields);
    } else {
      pages[Number(pageIndex)].rows[Number(rowIndex)].columns[Number(columnIndex)].fields = fields;
    }

    return pages;
  };

  exports.setColumnFields = setColumnFields;

  var removeColumn = function removeColumn(pages, pageIndex, rowIndex, columnIndex) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapRows(function (row, currentRowIndex, currentPageIndex) {
      var newRow = row;

      if (currentRowIndex === rowIndex && currentPageIndex === pageIndex) {
        newRow = _objectSpread({}, row, {
          columns: row.columns.filter(function (col, currentColumnIndex) {
            return currentColumnIndex !== columnIndex;
          })
        });
      }

      return newRow;
    });
  };

  exports.removeColumn = removeColumn;

  var removeFields = function removeFields(pages, pageIndex, rowIndex, columnIndex) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapColumns(function (column, currentColumnIndex, currentRowIndex, currentPageIndex) {
      var newColumn = _objectSpread({}, column);

      if (currentPageIndex === pageIndex && currentRowIndex === rowIndex && currentColumnIndex === columnIndex) {
        newColumn.fields = [];
      }

      return newColumn;
    });
  };

  exports.removeFields = removeFields;

  var removeEmptyRows = function removeEmptyRows(pages, pageIndex) {
    return pages[pageIndex].rows.reduce(function (result, next, index) {
      if (rowHasFields(pages, pageIndex, index)) {
        result = [].concat(_toConsumableArray(result), [next]);
      }

      return result;
    }, []);
  };

  exports.removeEmptyRows = removeEmptyRows;

  var removeRow = function removeRow(pages, pageIndex, rowIndex) {
    pages[Number(pageIndex)].rows.splice(Number(rowIndex), 1);
    return pages;
  };

  exports.removeRow = removeRow;

  var findFieldByName = function findFieldByName(pages, name) {
    var field = null;
    var visitor = new _visitors.PagesVisitor(pages);
    visitor.mapFields(function (currentField) {
      if (currentField.fieldName === name) {
        field = currentField;
      }
    });
    return field;
  };

  exports.findFieldByName = findFieldByName;

  var getColumn = function getColumn(pages, pageIndex, rowIndex, columnIndex) {
    var row = getRow(pages, pageIndex, rowIndex);
    return row.columns[Number(columnIndex)];
  };

  exports.getColumn = getColumn;

  var getColumnPosition = function getColumnPosition(pages, pageIndex, rowIndex, columnIndex) {
    return columnIndex != -1 ? pages[pageIndex].rows[rowIndex].columns.reduce(function (result, next, index) {
      if (index <= columnIndex) {
        var column = getColumn(pages, pageIndex, rowIndex, index);
        result += column.size;
      }

      return result;
    }, 0) : 0;
  };

  exports.getColumnPosition = getColumnPosition;

  var getField = function getField(pages, pageIndex, rowIndex, columnIndex) {
    return getColumn(pages, pageIndex, rowIndex, columnIndex).fields[0];
  };

  exports.getField = getField;

  var getRow = function getRow(pages, pageIndex, rowIndex) {
    return pages[Number(pageIndex)].rows[Number(rowIndex)];
  };

  exports.getRow = getRow;

  var rowHasFields = function rowHasFields(pages, pageIndex, rowIndex) {
    var hasFields = false;
    var page = pages[Number(pageIndex)];

    if (page) {
      var row = page.rows[Number(rowIndex)];

      if (row) {
        hasFields = row.columns.some(function (column) {
          return column.fields.length;
        });
      }
    }

    return hasFields;
  };

  exports.rowHasFields = rowHasFields;

  var getIndexes = function getIndexes(node) {
    var _node$dataset = node.dataset,
        ddmFieldColumn = _node$dataset.ddmFieldColumn,
        ddmFieldPage = _node$dataset.ddmFieldPage,
        ddmFieldRow = _node$dataset.ddmFieldRow;
    return {
      columnIndex: Number(ddmFieldColumn) || 0,
      pageIndex: Number(ddmFieldPage) || 0,
      rowIndex: Number(ddmFieldRow) || 0
    };
  };

  exports.getIndexes = getIndexes;

  var updateField = function updateField(pages, fieldName, properties) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapFields(function (field) {
      if (fieldName === field.fieldName) {
        field = _objectSpread({}, field, properties);
      }

      return field;
    });
  };

  exports.updateField = updateField;

  var updateColumn = function updateColumn(pages, pageIndex, rowIndex, columnIndex, properties) {
    var visitor = new _visitors.PagesVisitor(pages);
    return visitor.mapColumns(function (column, currentColumnIndex, currentRowIndex, currentPageIndex) {
      var newColumn = column;

      if (currentColumnIndex === columnIndex && currentRowIndex === rowIndex && currentPageIndex === pageIndex) {
        newColumn = _objectSpread({}, column, properties);
      }

      return newColumn;
    });
  };

  exports.updateColumn = updateColumn;
  //# sourceMappingURL=FormSupport.es.js.map
});
//# sourceMappingURL=FormSupport.es.js.map