/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal.servlet;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContext;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderTracker;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class DDMDataProviderServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderServlet.class);
    private static final long serialVersionUID = 1L;
    private DDMDataProviderInstanceService _ddmDataProviderInstanceService;
    private DDMDataProviderTracker _ddmDataProviderTracker;
    private DDMFormValuesJSONDeserializer _ddmFormValuesJSONDeserializer;
    private JSONFactory _jsonFactory;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("osgi.http.whiteboard.context.path", "/dynamic-data-mapping-data-provider");
        properties.put("filter.init.auth.verifier.PortalSessionAuthVerifier.urls.includes", "/dynamic-data-mapping-data-provider/*");
        properties.put("osgi.http.whiteboard.filter.name", "AuthVerifierFilter");
        properties.put("osgi.http.whiteboard.filter.pattern", "/dynamic-data-mapping-data-provider/*");
        bundleContext.registerService(Filter.class, (Object)new AuthVerifierFilter(), properties);
        properties = new Hashtable();
        properties.put("osgi.http.whiteboard.context.path", "/dynamic-data-mapping-data-provider");
        properties.put("osgi.http.whiteboard.servlet.name", "DDMDataProviderServlet");
        properties.put("osgi.http.whiteboard.servlet.pattern", "/dynamic-data-mapping-data-provider/*");
        properties.put("servlet.init.httpMethods", "GET,POST,HEAD");
        bundleContext.registerService(Servlet.class, (Object)this, properties);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long ddmDataProviderInstanceId = ParamUtil.getLong((HttpServletRequest)request, (String)"ddmDataProviderInstanceId");
        String data = this.doGetData(ddmDataProviderInstanceId);
        if (data == null) {
            response.sendError(400);
            return;
        }
        response.setContentType("application/json");
        response.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)response, (String)data);
    }

    protected String doGetData(long ddmDataProviderInstanceId) {
        try {
            DDMDataProviderInstance ddmDataProviderInstance = this._ddmDataProviderInstanceService.getDataProviderInstance(ddmDataProviderInstanceId);
            DDMDataProvider ddmDataProvider = this._ddmDataProviderTracker.getDDMDataProvider(ddmDataProviderInstance.getType());
            DDMForm ddmForm = DDMFormFactory.create(ddmDataProvider.getSettings());
            DDMFormValues ddmFormValues = this._ddmFormValuesJSONDeserializer.deserialize(ddmForm, ddmDataProviderInstance.getDefinition());
            DDMDataProviderContext ddmDataProviderContext = new DDMDataProviderContext(ddmFormValues);
            JSONArray jsonArray = this.toJSONArray(ddmDataProvider.getData(ddmDataProviderContext));
            return jsonArray.toString();
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    @Reference(unbind="-")
    protected void setDDMDataProviderInstanceService(DDMDataProviderInstanceService ddmDataProviderInstanceService) {
        this._ddmDataProviderInstanceService = ddmDataProviderInstanceService;
    }

    @Reference(unbind="-")
    protected void setDDMDataProviderTracker(DDMDataProviderTracker ddmDataProviderTracker) {
        this._ddmDataProviderTracker = ddmDataProviderTracker;
    }

    @Reference(unbind="-")
    protected void setDDMFormValuesJSONDeserializer(DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer) {
        this._ddmFormValuesJSONDeserializer = ddmFormValuesJSONDeserializer;
    }

    @Reference(unbind="-")
    protected void setJSONFactory(JSONFactory jsonFactory) {
        this._jsonFactory = jsonFactory;
    }

    protected JSONArray toJSONArray(List<KeyValuePair> keyValuePairs) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        for (KeyValuePair keyValuePair : keyValuePairs) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            JSONObject labelJSONObject = this._jsonFactory.createJSONObject();
            labelJSONObject.put(LanguageUtil.getLanguageId((Locale)LocaleUtil.getDefault()), keyValuePair.getKey());
            jsonObject.put("label", labelJSONObject);
            jsonObject.put("value", keyValuePair.getValue());
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }
}

