/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDMDataProviderTracker.class})
public class DDMDataProviderTracker {
    private final Map<String, DDMDataProvider> _ddmDataProvidersMap = new ConcurrentHashMap<String, DDMDataProvider>();

    public DDMDataProvider getDDMDataProvider(String type) {
        return this._ddmDataProvidersMap.get(type);
    }

    public Set<String> getDDMDataProviderTypes() {
        return Collections.unmodifiableSet(this._ddmDataProvidersMap.keySet());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unregisterDDMDataProvider")
    protected synchronized void registerDDMDataProvider(DDMDataProvider ddmDataProvider, Map<String, Object> properties) {
        Object value = properties.get("ddm.data.provider.type");
        this._ddmDataProvidersMap.put(value.toString(), ddmDataProvider);
    }

    protected synchronized void unregisterDDMDataProvider(DDMDataProvider ddmDataProvider, Map<String, Object> properties) {
        Object value = properties.get("ddm.data.provider.type");
        this._ddmDataProvidersMap.remove(value);
    }
}

