/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.web.internal.display.context;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderTracker;
import com.liferay.dynamic.data.mapping.data.provider.display.DDMDataProviderDisplay;
import com.liferay.dynamic.data.mapping.data.provider.web.internal.display.DDMDataProviderDisplayTracker;
import com.liferay.dynamic.data.mapping.data.provider.web.internal.display.context.util.DDMDataProviderRequestHelper;
import com.liferay.dynamic.data.mapping.data.provider.web.internal.search.DDMDataProviderSearch;
import com.liferay.dynamic.data.mapping.data.provider.web.internal.security.permission.resource.DDMDataProviderInstancePermission;
import com.liferay.dynamic.data.mapping.data.provider.web.internal.security.permission.resource.DDMFormPermission;
import com.liferay.dynamic.data.mapping.data.provider.web.internal.util.DDMDataProviderPortletUtil;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializer;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesDeserializerDeserializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMDisplayTabItem;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutFactory;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class DDMDataProviderDisplayContext {
    private static final String[] _DISPLAY_VIEWS = new String[]{"descriptive", "list"};
    private final DDMDataProviderDisplayTracker _ddmDataProviderDisplayTracker;
    private DDMDataProviderInstance _ddmDataProviderInstance;
    private final DDMDataProviderInstanceService _ddmDataProviderInstanceService;
    private final DDMDataProviderRequestHelper _ddmDataProviderRequestHelper;
    private final DDMDataProviderTracker _ddmDataProviderTracker;
    private final DDMFormRenderer _ddmFormRenderer;
    private final DDMFormValuesDeserializer _ddmFormValuesDeserializer;
    private String _displayStyle;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final UserLocalService _userLocalService;

    public DDMDataProviderDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, DDMDataProviderDisplayTracker ddmDataProviderDisplayTracker, DDMDataProviderInstanceService ddmDataProviderInstanceService, DDMDataProviderTracker ddmDataProviderTracker, DDMFormRenderer ddmFormRenderer, DDMFormValuesDeserializer ddmFormValuesDeserializer, UserLocalService userLocalService) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._ddmDataProviderDisplayTracker = ddmDataProviderDisplayTracker;
        this._ddmDataProviderInstanceService = ddmDataProviderInstanceService;
        this._ddmDataProviderTracker = ddmDataProviderTracker;
        this._ddmFormRenderer = ddmFormRenderer;
        this._ddmFormValuesDeserializer = ddmFormValuesDeserializer;
        this._userLocalService = userLocalService;
        this._ddmDataProviderRequestHelper = new DDMDataProviderRequestHelper(renderRequest);
    }

    public DDMDataProviderInstance fetchDataProviderInstance() throws PortalException {
        if (this._ddmDataProviderInstance != null) {
            return this._ddmDataProviderInstance;
        }
        long dataProviderInstanceId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"dataProviderInstanceId");
        this._ddmDataProviderInstance = this._ddmDataProviderInstanceService.fetchDataProviderInstance(dataProviderInstanceId);
        return this._ddmDataProviderInstance;
    }

    public List<DropdownItem> getActionItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteDataProviderInstances");
                    dropdownItem.setIcon("times-circle");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDMDataProviderDisplayContext.this._ddmDataProviderRequestHelper.getRequest(), (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClearResultsURL() throws PortletException {
        PortletURL clearResultsURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() {
        if (!this.isShowAddDataProviderButton()) {
            return null;
        }
        return new CreationMenu(){
            {
                for (String ddmDataProviderType : DDMDataProviderDisplayContext.this.getDDMDataProviderTypes()) {
                    this.addPrimaryDropdownItem(DDMDataProviderDisplayContext.this.getCreationMenuDropdownItem(ddmDataProviderType));
                }
            }
        };
    }

    public String getDataProviderInstanceDDMFormHTML() throws PortalException {
        DDMDataProviderInstance ddmDataProviderInstance = this.fetchDataProviderInstance();
        String type = BeanParamUtil.getString((Object)ddmDataProviderInstance, (PortletRequest)this._renderRequest, (String)"type");
        DDMDataProvider ddmDataProvider = this._ddmDataProviderTracker.getDDMDataProvider(type);
        Class clazz = ddmDataProvider.getSettings();
        DDMForm ddmForm = DDMFormFactory.create((Class)clazz);
        DDMFormRenderingContext ddmFormRenderingContext = this.createDDMFormRenderingContext();
        if (this._ddmDataProviderInstance != null) {
            DDMFormValues ddmFormValues = this.deserialize(ddmDataProviderInstance.getDefinition(), ddmForm);
            Set<String> passwordDDMFormFieldNames = DDMDataProviderPortletUtil.getDDMFormFieldNamesByType(ddmForm, "password");
            this.obfuscateDDMFormFieldValues(passwordDDMFormFieldNames, ddmFormValues.getDDMFormFieldValues());
            ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
        }
        DDMFormLayout ddmFormLayout = DDMFormLayoutFactory.create((Class)clazz);
        ddmFormLayout.setPaginationMode("single-page");
        return this._ddmFormRenderer.render(ddmForm, ddmFormLayout, ddmFormRenderingContext);
    }

    public String getDataProviderInstanceDescription() throws PortalException {
        DDMDataProviderInstance ddmDataProviderInstance = this.fetchDataProviderInstance();
        if (ddmDataProviderInstance == null) {
            return "";
        }
        return ddmDataProviderInstance.getDescription(this._renderRequest.getLocale());
    }

    public String getDataProviderInstanceName() throws PortalException {
        DDMDataProviderInstance ddmDataProviderInstance = this.fetchDataProviderInstance();
        if (ddmDataProviderInstance == null) {
            return "";
        }
        return ddmDataProviderInstance.getName(this._renderRequest.getLocale());
    }

    public String getDisplayStyle() {
        if (this._displayStyle == null) {
            this._displayStyle = this.getDisplayStyle((PortletRequest)this._renderRequest, this.getDisplayViews());
        }
        return this._displayStyle;
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        final HttpServletRequest httpServletRequest = this._ddmDataProviderRequestHelper.getRequest();
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDMDataProviderDisplayContext.this.getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDMDataProviderDisplayContext.this.getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"order-by"));
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItems(final LiferayPortletRequest liferayPortletRequest, final LiferayPortletResponse liferayPortletResponse) throws Exception {
        return new NavigationItemList(){
            {
                DDMDataProviderDisplay ddmDataProviderDisplay = DDMDataProviderDisplayContext.this.getDDMDataProviderDisplay();
                for (DDMDisplayTabItem ddmDisplayTabItem : ddmDataProviderDisplay.getDDMDisplayTabItems()) {
                    if (!ddmDisplayTabItem.isShow(liferayPortletRequest)) continue;
                    String ddmDisplayTabItemTitle = GetterUtil.getString((String)ddmDisplayTabItem.getTitle(liferayPortletRequest, liferayPortletResponse));
                    DDMDisplayTabItem defaultDDMDisplayTabItem = ddmDataProviderDisplay.getDefaultDDMDisplayTabItem();
                    String defaultDDMDisplayTabItemTitle = GetterUtil.getString((String)defaultDDMDisplayTabItem.getTitle(liferayPortletRequest, liferayPortletResponse));
                    String ddmDisplayTabItemHREF = GetterUtil.getString((String)ddmDisplayTabItem.getURL(liferayPortletRequest, liferayPortletResponse));
                    this.add(navigationItem -> {
                        navigationItem.setActive(Objects.equals(ddmDisplayTabItemTitle, defaultDDMDisplayTabItemTitle));
                        navigationItem.setHref((Object)ddmDisplayTabItemHREF);
                        navigationItem.setLabel(ddmDisplayTabItemTitle);
                    });
                }
            }
        };
    }

    public String getOrderByCol() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"modified-date");
    }

    public String getOrderByType() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        String keywords;
        String displayStyle;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view.jsp");
        portletURL.setParameter("groupId", String.valueOf(this._ddmDataProviderRequestHelper.getScopeGroupId()));
        String delta = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"delta");
        if (Validator.isNotNull((String)delta)) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(displayStyle = this.getDisplayStyle()))) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        if (Validator.isNotNull((String)(keywords = this.getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        portletURL.setParameter("refererPortletName", this.getRefererPortletName());
        return portletURL;
    }

    public SearchContainer<?> getSearch() {
        String displayStyle = this.getDisplayStyle();
        PortletURL portletURL = this.getPortletURL();
        portletURL.setParameter("displayStyle", displayStyle);
        DDMDataProviderSearch ddmDataProviderSearch = new DDMDataProviderSearch((PortletRequest)this._renderRequest, portletURL);
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator<DDMDataProviderInstance> orderByComparator = DDMDataProviderPortletUtil.getDDMDataProviderOrderByComparator(orderByCol, orderByType);
        ddmDataProviderSearch.setOrderByCol(orderByCol);
        ddmDataProviderSearch.setOrderByComparator(orderByComparator);
        ddmDataProviderSearch.setOrderByType(orderByType);
        if (ddmDataProviderSearch.isSearch()) {
            ddmDataProviderSearch.setEmptyResultsMessage("no-data-providers-were-found");
        } else {
            ddmDataProviderSearch.setEmptyResultsMessage("there-are-no-data-providers");
        }
        this.setDDMDataProviderInstanceSearchResults(ddmDataProviderSearch);
        this.setDDMDataProviderInstanceSearchTotal(ddmDataProviderSearch);
        return ddmDataProviderSearch;
    }

    public String getSearchContainerId() {
        return "dataProviderInstance";
    }

    public String getSortingURL() throws Exception {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (MimeResponse)this._renderResponse);
        String orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType");
        sortingURL.setParameter("orderByType", orderByType.equals("asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public String getTitle() {
        DDMDataProviderDisplay ddmDataProviderDisplay = this.getDDMDataProviderDisplay();
        return ddmDataProviderDisplay.getTitle(this._renderRequest.getLocale());
    }

    public int getTotalItems() {
        SearchContainer<?> searchContainer = this.getSearch();
        return searchContainer.getTotal();
    }

    public String getUserPortraitURL(long userId) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        return user.getPortraitURL(this._ddmDataProviderRequestHelper.getThemeDisplay());
    }

    public List<ViewTypeItem> getViewTypesItems() {
        return new ViewTypeItemList(this.getPortletURL(), this.getDisplayStyle()){
            {
                String[] viewTypes;
                super(x0, x1);
                for (String viewType : viewTypes = DDMDataProviderDisplayContext.this.getDisplayViews()) {
                    if (viewType.equals("descriptive")) {
                        this.addListViewTypeItem();
                        continue;
                    }
                    this.addTableViewTypeItem();
                }
            }
        };
    }

    public boolean isDisabledManagementBar() {
        return !this.hasResults() && !this.isSearch();
    }

    public boolean isShowBackIcon() {
        return ParamUtil.getBoolean((PortletRequest)this._renderRequest, (String)"showBackIcon", (boolean)true);
    }

    public boolean isShowDeleteDataProviderIcon(DDMDataProviderInstance dataProviderInstance) throws PortalException {
        return DDMDataProviderInstancePermission.contains(this._ddmDataProviderRequestHelper.getPermissionChecker(), dataProviderInstance, "DELETE");
    }

    public boolean isShowEditDataProviderIcon(DDMDataProviderInstance dataProviderInstance) throws PortalException {
        return DDMDataProviderInstancePermission.contains(this._ddmDataProviderRequestHelper.getPermissionChecker(), dataProviderInstance, "UPDATE");
    }

    public boolean isShowPermissionsIcon(DDMDataProviderInstance dataProviderInstance) throws PortalException {
        return DDMDataProviderInstancePermission.contains(this._ddmDataProviderRequestHelper.getPermissionChecker(), dataProviderInstance, "PERMISSIONS");
    }

    protected DDMFormRenderingContext createDDMFormRenderingContext() {
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setHttpServletRequest(this._ddmDataProviderRequestHelper.getRequest());
        ddmFormRenderingContext.setHttpServletResponse(PortalUtil.getHttpServletResponse((PortletResponse)this._renderResponse));
        ddmFormRenderingContext.setLocale(this._ddmDataProviderRequestHelper.getLocale());
        ddmFormRenderingContext.setPortletNamespace(this._renderResponse.getNamespace());
        ddmFormRenderingContext.setShowRequiredFieldsWarning(false);
        return ddmFormRenderingContext;
    }

    protected DDMFormValues deserialize(String content, DDMForm ddmForm) {
        DDMFormValuesDeserializerDeserializeRequest.Builder builder = DDMFormValuesDeserializerDeserializeRequest.Builder.newBuilder((String)content, (DDMForm)ddmForm);
        DDMFormValuesDeserializerDeserializeResponse ddmFormValuesDeserializerDeserializeResponse = this._ddmFormValuesDeserializer.deserialize(builder.build());
        return ddmFormValuesDeserializerDeserializeResponse.getDDMFormValues();
    }

    protected UnsafeConsumer<DropdownItem, Exception> getCreationMenuDropdownItem(String ddmDataProviderType) {
        HttpServletRequest httpServletRequest = this._ddmDataProviderRequestHelper.getRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return dropdownItem -> {
            dropdownItem.setHref(this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_data_provider.jsp", "redirect", PortalUtil.getCurrentURL((HttpServletRequest)httpServletRequest), "groupId", String.valueOf(themeDisplay.getScopeGroupId()), "type", ddmDataProviderType});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)ddmDataProviderType));
        };
    }

    protected DDMDataProviderDisplay getDDMDataProviderDisplay() {
        return this._ddmDataProviderDisplayTracker.getDDMDataProviderDisplay(this.getRefererPortletName());
    }

    protected Set<String> getDDMDataProviderTypes() {
        return this._ddmDataProviderTracker.getDDMDataProviderTypes();
    }

    protected String getDisplayStyle(PortletRequest portletRequest, String[] displayViews) {
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
        String displayStyle = ParamUtil.getString((PortletRequest)portletRequest, (String)"displayStyle");
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = portalPreferences.getValue("com_liferay_dynamic_data_mapping_data_provider_web_portlet_DDMDataProviderPortlet", "display-style", "descriptive");
        } else if (ArrayUtil.contains((Object[])displayViews, (Object)displayStyle)) {
            portalPreferences.setValue("com_liferay_dynamic_data_mapping_data_provider_web_portlet_DDMDataProviderPortlet", "display-style", displayStyle);
        }
        if (!ArrayUtil.contains((Object[])displayViews, (Object)displayStyle)) {
            displayStyle = displayViews[0];
        }
        return displayStyle;
    }

    protected String[] getDisplayViews() {
        return _DISPLAY_VIEWS;
    }

    protected List<DropdownItem> getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(DDMDataProviderDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDMDataProviderDisplayContext.this._ddmDataProviderRequestHelper.getRequest(), (String)"all"));
                });
            }
        };
    }

    protected String getKeywords() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
    }

    protected UnsafeConsumer<DropdownItem, Exception> getOrderByDropdownItem(String orderByCol) {
        return dropdownItem -> {
            dropdownItem.setActive(orderByCol.equals(this.getOrderByCol()));
            dropdownItem.setHref(this.getPortletURL(), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._ddmDataProviderRequestHelper.getRequest(), (String)orderByCol));
        };
    }

    protected List<DropdownItem> getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(DDMDataProviderDisplayContext.this.getOrderByDropdownItem("modified-date"));
                this.add(DDMDataProviderDisplayContext.this.getOrderByDropdownItem("name"));
            }
        };
    }

    protected String getRefererPortletName() {
        return ParamUtil.getString((HttpServletRequest)this._ddmDataProviderRequestHelper.getRequest(), (String)"refererPortletName", (String)this._ddmDataProviderRequestHelper.getPortletName());
    }

    protected boolean hasResults() {
        return this.getTotalItems() > 0;
    }

    protected boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    protected boolean isShowAddDataProviderButton() {
        return DDMFormPermission.contains(this._ddmDataProviderRequestHelper.getPermissionChecker(), this._ddmDataProviderRequestHelper.getScopeGroupId(), "ADD_DATA_PROVIDER_INSTANCE");
    }

    protected void obfuscateDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        for (Locale availableLocale : value.getAvailableLocales()) {
            value.addString(availableLocale, "TEMP_OBFUSCATION_VALUE");
        }
    }

    protected void obfuscateDDMFormFieldValues(Set<String> ddmFormFieldNamesToBeObfuscated, List<DDMFormFieldValue> ddmFormFieldValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (ddmFormFieldNamesToBeObfuscated.contains(ddmFormFieldValue.getName())) {
                this.obfuscateDDMFormFieldValue(ddmFormFieldValue);
            }
            this.obfuscateDDMFormFieldValues(ddmFormFieldNamesToBeObfuscated, ddmFormFieldValue.getNestedDDMFormFieldValues());
        }
    }

    protected void setDDMDataProviderInstanceSearchResults(DDMDataProviderSearch ddmDataProviderSearch) {
        List results = this._ddmDataProviderInstanceService.search(this._ddmDataProviderRequestHelper.getCompanyId(), this._getGroupIds(), this.getKeywords(), ddmDataProviderSearch.getStart(), ddmDataProviderSearch.getEnd(), ddmDataProviderSearch.getOrderByComparator());
        ddmDataProviderSearch.setResults(results);
    }

    protected void setDDMDataProviderInstanceSearchTotal(DDMDataProviderSearch ddmDataProviderSearch) {
        int total = this._ddmDataProviderInstanceService.searchCount(this._ddmDataProviderRequestHelper.getCompanyId(), this._getGroupIds(), this.getKeywords());
        ddmDataProviderSearch.setTotal(total);
    }

    private long[] _getGroupIds() {
        long scopeGroupId = this._ddmDataProviderRequestHelper.getScopeGroupId();
        ThemeDisplay themeDisplay = this._ddmDataProviderRequestHelper.getThemeDisplay();
        Group scopeGroup = themeDisplay.getScopeGroup();
        if (scopeGroup.isStagingGroup()) {
            scopeGroupId = scopeGroup.getGroupId();
        }
        return new long[]{scopeGroupId};
    }
}

