/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.web.internal.display;

import com.liferay.dynamic.data.mapping.data.provider.display.DDMDataProviderDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDMDataProviderDisplayTracker.class})
public class DDMDataProviderDisplayTracker {
    private final Map<String, DDMDataProviderDisplay> _ddmDataProviderDisplay = new ConcurrentHashMap<String, DDMDataProviderDisplay>();

    public DDMDataProviderDisplay getDDMDataProviderDisplay(String portletId) {
        return this._ddmDataProviderDisplay.get(portletId);
    }

    public List<DDMDataProviderDisplay> getDDMDataProviderDisplays() {
        return this._getDDMDataProviderDisplays();
    }

    public String[] getPortletIds() {
        return this._getPortletIds();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDDMDataProviderDisplay(DDMDataProviderDisplay ddmDataProviderDisplay) {
        this._ddmDataProviderDisplay.put(ddmDataProviderDisplay.getPortletId(), ddmDataProviderDisplay);
    }

    @Deactivate
    protected void deactivate() {
        this._ddmDataProviderDisplay.clear();
    }

    protected void removeDDMDataProviderDisplay(DDMDataProviderDisplay ddmDataProviderDisplay) {
        this._ddmDataProviderDisplay.remove(ddmDataProviderDisplay.getPortletId());
    }

    private List<DDMDataProviderDisplay> _getDDMDataProviderDisplays() {
        return ListUtil.fromMapValues(this._ddmDataProviderDisplay);
    }

    private String[] _getPortletIds() {
        Set<String> portletIds = this._ddmDataProviderDisplay.keySet();
        return portletIds.toArray(new String[0]);
    }
}

