/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.web.internal.portlet.action.AddDataProviderMVCActionCommand;
import com.liferay.dynamic.data.mapping.data.provider.web.internal.util.DDMDataProviderPortletUtil;
import com.liferay.dynamic.data.mapping.io.DDMFormValuesJSONDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_mapping_data_provider_web_portlet_DDMDataProviderPortlet", "mvc.command.name=updateDataProvider"}, service={MVCActionCommand.class})
public class UpdateDataProviderMVCActionCommand
extends AddDataProviderMVCActionCommand {
    @Reference
    protected DDMFormValuesJSONDeserializer ddmFormValuesJSONDeserializer;

    @Override
    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long dataProviderInstanceId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"dataProviderInstanceId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        DDMFormValues ddmFormValues = this.getDDMFormValues(actionRequest, actionResponse);
        this.restorePasswordDDMFormFieldValues(dataProviderInstanceId, ddmFormValues);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DDMDataProviderInstance.class.getName(), (PortletRequest)actionRequest);
        this.ddmDataProviderInstanceService.updateDataProviderInstance(dataProviderInstanceId, this.getLocalizedMap(themeDisplay.getSiteDefaultLocale(), name), this.getLocalizedMap(themeDisplay.getSiteDefaultLocale(), description), ddmFormValues, serviceContext);
    }

    protected Optional<DDMFormFieldValue> findStoredDDMFormFieldValue(String name, String instanceId, DDMFormValues storedDDMFormValues) {
        HashSet<DDMFormFieldValue> storedDDMFormFieldValues = new HashSet<DDMFormFieldValue>();
        this.flattenDDMFormFieldValues(storedDDMFormValues.getDDMFormFieldValues(), storedDDMFormFieldValues);
        Stream storedDDMFormFieldValuesStream = storedDDMFormFieldValues.stream();
        Predicate<DDMFormFieldValue> predicate = ddmFormFieldValue -> Objects.equals(ddmFormFieldValue.getName(), name) && Objects.equals(ddmFormFieldValue.getInstanceId(), instanceId);
        Optional<DDMFormFieldValue> matchedDDMFormFieldValueOptional = storedDDMFormFieldValuesStream.filter(predicate).findFirst();
        return matchedDDMFormFieldValueOptional;
    }

    protected void flattenDDMFormFieldValues(List<DDMFormFieldValue> storedDDMFormFieldValues, Set<DDMFormFieldValue> collectedDDMFormFieldValues) {
        for (DDMFormFieldValue storedDDMFormFieldValue : storedDDMFormFieldValues) {
            collectedDDMFormFieldValues.add(storedDDMFormFieldValue);
            this.flattenDDMFormFieldValues(storedDDMFormFieldValue.getNestedDDMFormFieldValues(), collectedDDMFormFieldValues);
        }
    }

    protected DDMForm getDataProviderInstanceSettingsDDMForm(DDMDataProviderInstance dataProviderInstance) {
        DDMDataProvider ddmDataProvider = this.ddmDataProviderTracker.getDDMDataProvider(dataProviderInstance.getType());
        Class clazz = ddmDataProvider.getSettings();
        return DDMFormFactory.create((Class)clazz);
    }

    protected DDMFormValues getStoredDDMFormValues(DDMForm dataProviderInstanceSettingsDDMForm, String dataProviderInstanceDefinition) throws PortalException {
        return this.ddmFormValuesJSONDeserializer.deserialize(dataProviderInstanceSettingsDDMForm, dataProviderInstanceDefinition);
    }

    protected void restoreDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, DDMFormFieldValue storedDDMFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        Value storedValue = storedDDMFormFieldValue.getValue();
        for (Locale availableLocale : value.getAvailableLocales()) {
            if (!Objects.equals(value.getString(availableLocale), "TEMP_OBFUSCATION_VALUE")) continue;
            value.addString(availableLocale, storedValue.getString(availableLocale));
        }
    }

    protected void restoreDDMFormFieldValue(DDMFormFieldValue ddmFormFieldValue, DDMFormValues storedDDMFormValues) {
        Optional<DDMFormFieldValue> storedFormFieldValueOptional = this.findStoredDDMFormFieldValue(ddmFormFieldValue.getName(), ddmFormFieldValue.getInstanceId(), storedDDMFormValues);
        storedFormFieldValueOptional.ifPresent(storedDDMFormFieldValue -> this.restoreDDMFormFieldValue(ddmFormFieldValue, (DDMFormFieldValue)storedDDMFormFieldValue));
    }

    protected void restoreDDMFormFieldValues(Set<String> ddmFormFieldNamesToBeRestored, List<DDMFormFieldValue> ddmFormFieldValues, DDMFormValues storedDDMFormValues) {
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (ddmFormFieldNamesToBeRestored.contains(ddmFormFieldValue.getName())) {
                this.restoreDDMFormFieldValue(ddmFormFieldValue, storedDDMFormValues);
            }
            this.restoreDDMFormFieldValues(ddmFormFieldNamesToBeRestored, ddmFormFieldValue.getNestedDDMFormFieldValues(), storedDDMFormValues);
        }
    }

    protected void restorePasswordDDMFormFieldValues(long dataProviderInstanceId, DDMFormValues ddmFormValues) throws PortalException {
        DDMDataProviderInstance dataProviderInstance = this.ddmDataProviderInstanceService.getDataProviderInstance(dataProviderInstanceId);
        DDMForm dataProviderInstanceSettingsDDMForm = this.getDataProviderInstanceSettingsDDMForm(dataProviderInstance);
        Set<String> passwordDDMFormFieldNames = DDMDataProviderPortletUtil.getDDMFormFieldNamesByType(dataProviderInstanceSettingsDDMForm, "password");
        DDMFormValues storedDDMFormValues = this.getStoredDDMFormValues(dataProviderInstanceSettingsDDMForm, dataProviderInstance.getDefinition());
        this.restoreDDMFormFieldValues(passwordDDMFormFieldNames, ddmFormValues.getDDMFormFieldValues(), storedDDMFormValues);
    }
}

