/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.instance;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContext;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseOutput;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"ddm.data.provider.instance.id=workflow-definitions"})
public class WorkflowDefinitionsDataProvider
implements DDMDataProvider {
    @Reference
    private Portal _portal;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(proxy.bean=false)")
    private volatile WorkflowDefinitionManager _workflowDefinitionManager;

    public List<KeyValuePair> getData(DDMDataProviderContext ddmDataProviderContext) throws DDMDataProviderException {
        return Collections.emptyList();
    }

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        ArrayList<KeyValuePair> data = new ArrayList<KeyValuePair>();
        Locale locale = this.getLocale(ddmDataProviderRequest.getHttpServletRequest());
        data.add(new KeyValuePair("no-workflow", LanguageUtil.get((Locale)locale, (String)"no-workflow")));
        if (this._workflowDefinitionManager == null) {
            return DDMDataProviderResponse.of((DDMDataProviderResponseOutput[])new DDMDataProviderResponseOutput[]{DDMDataProviderResponseOutput.of((String)"Default-Output", (String)"list", data)});
        }
        try {
            long companyId = this.getCompanyId(ddmDataProviderRequest.getHttpServletRequest());
            List workflowDefinitions = this._workflowDefinitionManager.getActiveWorkflowDefinitions(companyId, -1, -1, null);
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            for (WorkflowDefinition workflowDefinition : workflowDefinitions) {
                String value = workflowDefinition.getName() + "@" + workflowDefinition.getVersion();
                data.add(new KeyValuePair(value, workflowDefinition.getTitle(languageId)));
            }
        }
        catch (WorkflowException we) {
            throw new DDMDataProviderException((Throwable)we);
        }
        return DDMDataProviderResponse.of((DDMDataProviderResponseOutput[])new DDMDataProviderResponseOutput[]{DDMDataProviderResponseOutput.of((String)"Default-Output", (String)"list", data)});
    }

    public Class<?> getSettings() {
        throw new UnsupportedOperationException();
    }

    protected long getCompanyId(HttpServletRequest httpServletRequest) {
        return this._portal.getCompanyId(httpServletRequest);
    }

    protected Locale getLocale(HttpServletRequest httpServletRequest) {
        return this._portal.getLocale(httpServletRequest);
    }
}

