/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal.rest;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInstanceSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseStatus;
import com.liferay.dynamic.data.mapping.data.provider.configuration.DDMDataProviderConfiguration;
import com.liferay.dynamic.data.mapping.data.provider.internal.rest.DDMRESTDataProviderSettings;
import com.liferay.dynamic.data.mapping.data.provider.settings.DDMDataProviderSettingsProvider;
import com.liferay.dynamic.data.mapping.model.DDMDataProviderInstance;
import com.liferay.dynamic.data.mapping.service.DDMDataProviderInstanceService;
import com.liferay.petra.json.web.service.client.JSONWebServiceClient;
import com.liferay.petra.json.web.service.client.JSONWebServiceClientFactory;
import com.liferay.petra.json.web.service.client.JSONWebServiceException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.dynamic.data.mapping.data.provider.configuration.DDMDataProviderConfiguration"}, immediate=true, property={"ddm.data.provider.type=rest"}, service={DDMDataProvider.class})
public class DDMRESTDataProvider
implements DDMDataProvider {
    private static final Log _log = LogFactoryUtil.getLog(DDMRESTDataProvider.class);
    private static final Pattern _pathParameterPattern = Pattern.compile("\\{(.+?)\\}");
    private volatile DDMDataProviderConfiguration _ddmDataProviderConfiguration;
    @Reference
    private DDMDataProviderInstanceService _ddmDataProviderInstanceService;
    @Reference
    private DDMDataProviderInstanceSettings _ddmDataProviderInstanceSettings;
    @Reference(target="(ddm.data.provider.type=rest)")
    private DDMDataProviderSettingsProvider _ddmDataProviderSettingsProvider;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private JSONWebServiceClientFactory _jsonWebServiceClientFactory;
    private PortalCache<String, DDMDataProviderResponse> _portalCache;

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        try {
            Optional<DDMDataProviderInstance> ddmDataProviderInstanceOptional = this._getDDMDataProviderInstanceOptional(ddmDataProviderRequest.getDDMDataProviderId());
            if (!ddmDataProviderInstanceOptional.isPresent()) {
                DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
                return builder.withStatus(DDMDataProviderResponseStatus.SERVICE_UNAVAILABLE).build();
            }
            DDMRESTDataProviderSettings ddmRESTDataProviderSettings = (DDMRESTDataProviderSettings)this._ddmDataProviderInstanceSettings.getSettings(ddmDataProviderInstanceOptional.get(), DDMRESTDataProviderSettings.class);
            try {
                return this._getData(ddmDataProviderRequest, ddmRESTDataProviderSettings);
            }
            catch (JSONWebServiceException jsonWebServiceException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)jsonWebServiceException, (Throwable)jsonWebServiceException);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("The data provider was not able to connect to the web service. " + (Object)((Object)jsonWebServiceException)));
                }
                return this._createDDMDataProviderResponse(JsonPath.parse((String)"{}"), ddmDataProviderRequest, DDMDataProviderResponseStatus.SERVICE_UNAVAILABLE, ddmRESTDataProviderSettings);
            }
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            throw new DDMDataProviderException((Throwable)exception);
        }
    }

    public Class<?> getSettings() {
        return this._ddmDataProviderSettingsProvider.getSettings();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._ddmDataProviderConfiguration = (DDMDataProviderConfiguration)ConfigurableUtil.createConfigurable(DDMDataProviderConfiguration.class, properties);
    }

    private String _buildURL(Map<String, String> pathInputParametersMap, String url) {
        for (Map.Entry<String, String> urlInputParameter : pathInputParametersMap.entrySet()) {
            url = StringUtil.replaceFirst((String)url, (String)String.format("{%s}", urlInputParameter.getKey()), (String)HtmlUtil.escapeURL((String)urlInputParameter.getValue()));
        }
        return url;
    }

    private DDMDataProviderResponse _createDDMDataProviderResponse(DocumentContext documentContext, DDMDataProviderRequest ddmDataProviderRequest, DDMDataProviderResponseStatus ddmDataProviderResponseStatus, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        Object[] outputParameters = ddmRESTDataProviderSettings.outputParameters();
        DDMDataProviderResponse.Builder builder = DDMDataProviderResponse.Builder.newBuilder();
        builder.withStatus(ddmDataProviderResponseStatus);
        if (ArrayUtil.isEmpty((Object[])outputParameters)) {
            return builder.build();
        }
        for (Object outputParameter : outputParameters) {
            String[] paths;
            String normalizedValuePath;
            List values;
            String id = outputParameter.outputParameterId();
            String type = outputParameter.outputParameterType();
            String path = outputParameter.outputParameterPath();
            if (Objects.equals(type, "text")) {
                builder = builder.withOutput(id, documentContext.read(this._normalizePath(path), String.class, new Predicate[0]));
                continue;
            }
            if (Objects.equals(type, "number")) {
                builder = builder.withOutput(id, documentContext.read(this._normalizePath(path), Number.class, new Predicate[0]));
                continue;
            }
            if (!Objects.equals(type, "list") || (values = (List)documentContext.read(normalizedValuePath = this._normalizePath((paths = StringUtil.split((String)path, (char)';'))[0]), List.class, new Predicate[0])) == null) continue;
            List keys = values;
            if (paths.length >= 2) {
                keys = (List)documentContext.read(this._normalizePath(paths[1]), new Predicate[0]);
            }
            ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
            for (int i = 0; i < values.size(); ++i) {
                keyValuePairs.add(new KeyValuePair(String.valueOf(keys.get(i)), String.valueOf(values.get(i))));
            }
            if (ddmRESTDataProviderSettings.pagination()) {
                Optional paginationEndOptional = ddmDataProviderRequest.getParameterOptional("paginationEnd", String.class);
                int end = GetterUtil.getInteger((String)paginationEndOptional.orElse("10"));
                Optional paginationStartOptional = ddmDataProviderRequest.getParameterOptional("paginationStart", String.class);
                int start = GetterUtil.getInteger((String)paginationStartOptional.orElse("1"));
                if (keyValuePairs.size() <= end - start) continue;
                builder = builder.withOutput(id, (Object)ListUtil.subList(keyValuePairs, (int)start, (int)end));
                continue;
            }
            builder = builder.withOutput(id, keyValuePairs);
        }
        return builder.build();
    }

    private String _getAbsoluteURL(String query, String url) {
        if (query != null) {
            return StringUtil.replaceLast((String)url, (String)("?" + query), (String)"");
        }
        return url;
    }

    private List<KeyValuePair> _getAdditionalParameters(Map<String, String> pathInputParametersMap, Map<String, Object> requestInputParametersMap) {
        Set<Map.Entry<String, Object>> set = requestInputParametersMap.entrySet();
        Stream stream = set.stream();
        return stream.collect(ArrayList::new, (keyValuePairs, entry) -> {
            String key = (String)entry.getKey();
            if (!pathInputParametersMap.containsKey(key)) {
                keyValuePairs.add(new KeyValuePair(key, String.valueOf(entry.getValue())));
            }
        }, ArrayList::addAll);
    }

    private String _getCacheKey(String ddmDataProviderId, List<KeyValuePair> keyValuePairs, String url) {
        Stream stream = keyValuePairs.stream();
        return StringBundler.concat((String[])new String[]{ddmDataProviderId, "@", url, "?", stream.sorted().map(keyValuePair -> StringBundler.concat((String[])new String[]{keyValuePair.getKey(), "=", keyValuePair.getValue()})).collect(Collectors.joining("&"))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DDMDataProviderResponse _getData(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) throws Exception {
        Map<String, Object> requestInputParametersMap = this._getRequestInputParametersMap(ddmDataProviderRequest, ddmRESTDataProviderSettings);
        Map<String, String> pathInputParametersMap = this._getPathInputParametersMap(requestInputParametersMap, ddmRESTDataProviderSettings.url());
        List allParameters = ListUtil.toList(this._getAdditionalParameters(pathInputParametersMap, requestInputParametersMap));
        allParameters.addAll(this._getFilterAndPaginationParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings));
        String url = this._buildURL(pathInputParametersMap, ddmRESTDataProviderSettings.url());
        URI uri = new URI(url);
        allParameters.addAll(this._getQueryParameters(uri.getQuery()));
        String absoluteURL = this._getAbsoluteURL(uri.getQuery(), url);
        String cacheKey = this._getCacheKey(ddmDataProviderRequest.getDDMDataProviderId(), allParameters, absoluteURL);
        DDMDataProviderResponse ddmDataProviderResponse = (DDMDataProviderResponse)this._portalCache.get((Serializable)((Object)cacheKey));
        if (ddmDataProviderResponse != null && ddmRESTDataProviderSettings.cacheable()) {
            return ddmDataProviderResponse;
        }
        JSONWebServiceClient jsonWebServiceClient = this._jsonWebServiceClientFactory.getInstance((Map)HashMapBuilder.put((Object)"hostName", (Object)this._getHostName(uri.getHost())).put((Object)"hostPort", (Object)this._getHostPort(uri.getPort(), uri.getScheme())).put((Object)"keyStore", (Object)this._getKeyStore()).put((Object)"login", (Object)ddmRESTDataProviderSettings.username()).put((Object)"password", (Object)ddmRESTDataProviderSettings.password()).put((Object)"protocol", (Object)uri.getScheme()).put((Object)"trustSelfSignedCertificates", (Object)this._ddmDataProviderConfiguration.trustSelfSignedCertificates()).putAll(this._getProxySettingsMap()).build(), false);
        String response = null;
        try {
            response = jsonWebServiceClient.doGet(absoluteURL, this._getParametersArray(allParameters));
        }
        finally {
            jsonWebServiceClient.destroy();
        }
        jsonWebServiceClient.destroy();
        String sanitizedResponse = IOUtils.toString((InputStream)new BOMInputStream((InputStream)new ByteArrayInputStream(response.getBytes())), (Charset)StandardCharsets.UTF_8);
        ddmDataProviderResponse = this._createDDMDataProviderResponse(JsonPath.parse((String)sanitizedResponse), ddmDataProviderRequest, DDMDataProviderResponseStatus.OK, ddmRESTDataProviderSettings);
        if (ddmRESTDataProviderSettings.cacheable()) {
            this._portalCache.put((Serializable)((Object)cacheKey), (Object)ddmDataProviderResponse);
        }
        return ddmDataProviderResponse;
    }

    private Optional<DDMDataProviderInstance> _getDDMDataProviderInstanceOptional(String ddmDataProviderInstanceId) throws Exception {
        DDMDataProviderInstance ddmDataProviderInstance = this._ddmDataProviderInstanceService.fetchDataProviderInstanceByUuid(ddmDataProviderInstanceId);
        if (ddmDataProviderInstance == null && Validator.isNumber((String)ddmDataProviderInstanceId)) {
            ddmDataProviderInstance = this._ddmDataProviderInstanceService.fetchDataProviderInstance(Long.valueOf(ddmDataProviderInstanceId).longValue());
        }
        return Optional.ofNullable(ddmDataProviderInstance);
    }

    private List<KeyValuePair> _getFilterAndPaginationParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        ArrayList<KeyValuePair> keyValuePairs = new ArrayList<KeyValuePair>();
        if (ddmRESTDataProviderSettings.filterable()) {
            Optional filterParameterValueOptional = ddmDataProviderRequest.getParameterOptional("filterParameterValue", String.class);
            filterParameterValueOptional.ifPresent(filterParameterValueString -> keyValuePairs.add(new KeyValuePair(ddmRESTDataProviderSettings.filterParameterName(), filterParameterValueString)));
        }
        if (ddmRESTDataProviderSettings.pagination()) {
            Optional paginationEndOptional = ddmDataProviderRequest.getParameterOptional("paginationEnd", String.class);
            paginationEndOptional.ifPresent(paginationEndString -> keyValuePairs.add(new KeyValuePair(ddmRESTDataProviderSettings.paginationEndParameterName(), paginationEndString)));
            Optional paginationStartOptional = ddmDataProviderRequest.getParameterOptional("paginationStart", String.class);
            paginationStartOptional.ifPresent(paginationStartString -> keyValuePairs.add(new KeyValuePair(ddmRESTDataProviderSettings.paginationStartParameterName(), paginationStartString)));
        }
        return keyValuePairs;
    }

    private String _getHostName(String host) {
        if (StringUtil.startsWith((String)host, (String)"www.")) {
            return host.substring(4);
        }
        return host;
    }

    private int _getHostPort(int port, String scheme) {
        if (port == -1) {
            if (StringUtil.equals((String)scheme, (String)"https")) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    private KeyStore _getKeyStore() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        return keyStore;
    }

    private String[] _getParametersArray(List<KeyValuePair> keyValuePairs) {
        Stream stream = keyValuePairs.stream();
        return stream.collect(ArrayList::new, (parameters, keyValuePair) -> {
            parameters.add(keyValuePair.getKey());
            parameters.add(keyValuePair.getValue());
        }, ArrayList::addAll).toArray(new String[0]);
    }

    private Map<String, String> _getPathInputParametersMap(Map<String, Object> requestInputParametersMap, String url) {
        HashMap<String, String> pathInputParametersMap = new HashMap<String, String>();
        Matcher matcher = _pathParameterPattern.matcher(url);
        while (matcher.find()) {
            String pathParameterName = matcher.group(1);
            if (!requestInputParametersMap.containsKey(pathParameterName)) continue;
            pathInputParametersMap.put(pathParameterName, GetterUtil.getString((Object)requestInputParametersMap.get(pathParameterName)));
        }
        return pathInputParametersMap;
    }

    private Map<String, Object> _getProxySettingsMap() {
        HashMap<String, Object> proxySettingsMap;
        block3: {
            proxySettingsMap = new HashMap<String, Object>();
            try {
                String proxyHost = SystemProperties.get((String)"http.proxyHost");
                String proxyPort = SystemProperties.get((String)"http.proxyPort");
                if (Validator.isNotNull((String)proxyHost) && Validator.isNotNull((String)proxyPort)) {
                    proxySettingsMap.put("proxyHostName", proxyHost);
                    proxySettingsMap.put("proxyHostPort", GetterUtil.getInteger((String)proxyPort));
                }
            }
            catch (Exception exception) {
                proxySettingsMap.clear();
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to get proxy settings from system properties", (Throwable)exception);
            }
        }
        return proxySettingsMap;
    }

    private List<KeyValuePair> _getQueryParameters(String query) {
        return Stream.of(StringUtil.split((String)query, (String)"&")).collect(ArrayList::new, (keyValuePairs, queryParameter) -> {
            String[] queryParameterPartsMap = StringUtil.split((String)queryParameter, (String)"=");
            if (queryParameterPartsMap.length > 1) {
                keyValuePairs.add(new KeyValuePair(queryParameterPartsMap[0], queryParameterPartsMap[1]));
            } else {
                keyValuePairs.add(new KeyValuePair(queryParameterPartsMap[0], ""));
            }
        }, ArrayList::addAll);
    }

    private Map<String, Object> _getRequestInputParametersMap(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        Map parameters = ddmDataProviderRequest.getParameters();
        return Stream.of(ddmRESTDataProviderSettings.inputParameters()).filter(inputParameter -> parameters.containsKey(inputParameter.inputParameterName())).collect(HashMap::new, (parametersMap, inputParameter) -> parametersMap.put(inputParameter.inputParameterName(), parameters.get(inputParameter.inputParameterName())), HashMap::putAll);
    }

    private String _normalizePath(String path) {
        if (StringUtil.startsWith((String)path, (String)"$") || StringUtil.startsWith((String)path, (String)".") || StringUtil.startsWith((String)path, (String)"*")) {
            return path;
        }
        return ".".concat(path);
    }

    @Reference(unbind="-")
    private void _setMultiVMPool(MultiVMPool multiVMPool) {
        this._portalCache = multiVMPool.getPortalCache(DDMRESTDataProvider.class.getName());
    }
}

