/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.internal.rest.DDMRESTDataProviderSettings;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;

public class DDMDataProviderInvokeCommand
extends HystrixCommand<DDMDataProviderResponse> {
    private static final int _TIMEOUT_MAX = 30000;
    private static final int _TIMEOUT_MIN = 1000;
    private static final HystrixCommandGroupKey _hystrixCommandGroupKey = HystrixCommandGroupKey.Factory.asKey((String)"DDMDataProviderInvokeCommandGroup");
    private final DDMDataProvider _ddmDataProvider;
    private final DDMDataProviderRequest _ddmDataProviderRequest;
    private final PermissionChecker _permissionChecker;

    public DDMDataProviderInvokeCommand(String nameCurrentValue, DDMDataProvider ddmDataProvider, DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)_hystrixCommandGroupKey).andCommandKey(HystrixCommandKey.Factory.asKey((String)("DDMDataProviderInvokeCommand#" + nameCurrentValue))).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(DDMDataProviderInvokeCommand.getTimeout(ddmRESTDataProviderSettings))));
        this._ddmDataProvider = ddmDataProvider;
        this._ddmDataProviderRequest = ddmDataProviderRequest;
        this._permissionChecker = PermissionThreadLocal.getPermissionChecker();
    }

    protected static int getTimeout(DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        int timeout = GetterUtil.getInteger((String)ddmRESTDataProviderSettings.timeout());
        if (timeout >= 1000 && timeout <= 30000) {
            return timeout;
        }
        return 1000;
    }

    protected DDMDataProviderResponse run() throws Exception {
        PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._permissionChecker);
        return this._ddmDataProvider.getData(this._ddmDataProviderRequest);
    }

    static {
        HystrixPlugins histrixPlugins = HystrixPlugins.getInstance();
        histrixPlugins.registerPropertiesStrategy(new HystrixPropertiesStrategy(){

            public String getCommandPropertiesCacheKey(HystrixCommandKey hystrixCommandKey, HystrixCommandProperties.Setter setter) {
                return null;
            }
        });
    }
}

