/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal.rest;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContext;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderException;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderOutputParametersSettings;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseOutput;
import com.liferay.dynamic.data.mapping.data.provider.internal.rest.DDMRESTDataProviderSettings;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jodd.http.HttpException;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"ddm.data.provider.type=rest"}, service={DDMDataProvider.class})
public class DDMRESTDataProvider
implements DDMDataProvider {
    private static final Pattern _pathParameterPattern = Pattern.compile("\\{(.*)\\}");
    private PortalCache<String, DDMRESTDataProviderResult> _portalCache;

    public List<KeyValuePair> getData(DDMDataProviderContext ddmDataProviderContext) throws DDMDataProviderException {
        try {
            DDMDataProviderRequest ddmDataProviderRequest = this.createDDMDataProviderRequest(ddmDataProviderContext);
            DDMDataProviderResponse ddmDataProviderResponse = this.doGetData(ddmDataProviderRequest);
            DDMDataProviderResponseOutput ddmDataProviderResponseOutput = ddmDataProviderResponse.get("Default-Output");
            List results = (List)ddmDataProviderResponseOutput.getValue(List.class);
            return results;
        }
        catch (Exception e) {
            throw new DDMDataProviderException((Throwable)e);
        }
    }

    public DDMDataProviderResponse getData(DDMDataProviderRequest ddmDataProviderRequest) throws DDMDataProviderException {
        try {
            return this.doGetData(ddmDataProviderRequest);
        }
        catch (HttpException he) {
            Throwable cause = he.getCause();
            if (cause instanceof ConnectException) {
                return DDMDataProviderResponse.error((DDMDataProviderResponse.Status)DDMDataProviderResponse.Status.SERVICE_UNAVAILABLE);
            }
            throw new DDMDataProviderException((Throwable)he);
        }
        catch (Exception e) {
            throw new DDMDataProviderException((Throwable)e);
        }
    }

    public Class<?> getSettings() {
        return DDMRESTDataProviderSettings.class;
    }

    protected String buildURL(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        Map<String, String> pathParameters = this.getPathParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings);
        String url = ddmRESTDataProviderSettings.url();
        for (Map.Entry<String, String> pathParameter : pathParameters.entrySet()) {
            url = StringUtil.replaceFirst((String)url, (String)String.format("{%s}", pathParameter.getKey()), (String)pathParameter.getValue());
        }
        return url;
    }

    protected DDMDataProviderRequest createDDMDataProviderRequest(DDMDataProviderContext ddmDataProviderContext) {
        DDMDataProviderRequest ddmDataProviderRequest = new DDMDataProviderRequest(null, null);
        ddmDataProviderRequest.setDDMDataProviderContext(ddmDataProviderContext);
        ddmDataProviderRequest.queryString(ddmDataProviderContext.getParameters());
        return ddmDataProviderRequest;
    }

    protected DDMDataProviderResponse createDDMDataProviderResponse(DocumentContext documentContext, DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        DDMDataProviderOutputParametersSettings[] outputParameterSettingsArray = ddmRESTDataProviderSettings.outputParameters();
        if (outputParameterSettingsArray == null || outputParameterSettingsArray.length == 0) {
            return DDMDataProviderResponse.of((DDMDataProviderResponseOutput[])new DDMDataProviderResponseOutput[0]);
        }
        ArrayList<DDMDataProviderResponseOutput> ddmDataProviderResponseOutputs = new ArrayList<DDMDataProviderResponseOutput>();
        for (DDMDataProviderOutputParametersSettings outputParameterSettings : outputParameterSettingsArray) {
            String normalizedValuePath;
            Object value;
            String name = outputParameterSettings.outputParameterName();
            String type = outputParameterSettings.outputParameterType();
            String path = outputParameterSettings.outputParameterPath();
            if (Objects.equals(type, "text")) {
                value = (String)documentContext.read(this.normalizePath(path), String.class, new Predicate[0]);
                if (value == null) continue;
                ddmDataProviderResponseOutputs.add(DDMDataProviderResponseOutput.of((String)name, (String)"text", (Object)value));
                continue;
            }
            if (Objects.equals(type, "number")) {
                value = (Number)documentContext.read(this.normalizePath(path), Number.class, new Predicate[0]);
                if (value == null) continue;
                ddmDataProviderResponseOutputs.add(DDMDataProviderResponseOutput.of((String)name, (String)"number", (Object)value));
                continue;
            }
            if (!Objects.equals(type, "list")) continue;
            String[] paths = StringUtil.split((String)path, (char)';');
            String normalizedKeyPath = normalizedValuePath = this.normalizePath(paths[0]);
            List values = (List)documentContext.read(normalizedValuePath, List.class, new Predicate[0]);
            if (values == null) continue;
            List keys = new ArrayList(values);
            if (paths.length >= 2) {
                normalizedKeyPath = this.normalizePath(paths[1]);
                keys = (List)documentContext.read(normalizedKeyPath, new Predicate[0]);
            }
            List<Object> keyValuePairs = new ArrayList<KeyValuePair>();
            for (int i = 0; i < values.size(); ++i) {
                keyValuePairs.add(new KeyValuePair((String)keys.get(i), (String)values.get(i)));
            }
            if (ddmRESTDataProviderSettings.pagination()) {
                int start = Integer.valueOf(ddmDataProviderRequest.getParameter("paginationStart"));
                int end = Integer.valueOf(ddmDataProviderRequest.getParameter("paginationEnd"));
                if (keyValuePairs.size() > end - start) {
                    keyValuePairs = ListUtil.subList(keyValuePairs, (int)start, (int)end);
                }
            }
            ddmDataProviderResponseOutputs.add(DDMDataProviderResponseOutput.of((String)name, (String)"list", keyValuePairs));
        }
        int size = ddmDataProviderResponseOutputs.size();
        return DDMDataProviderResponse.of((DDMDataProviderResponseOutput[])ddmDataProviderResponseOutputs.toArray(new DDMDataProviderResponseOutput[size]));
    }

    protected DDMDataProviderResponse doGetData(DDMDataProviderRequest ddmDataProviderRequest) {
        DDMDataProviderContext ddmDataProviderContext = ddmDataProviderRequest.getDDMDataProviderContext();
        DDMRESTDataProviderSettings ddmRESTDataProviderSettings = (DDMRESTDataProviderSettings)ddmDataProviderContext.getSettingsInstance(DDMRESTDataProviderSettings.class);
        HttpRequest httpRequest = HttpRequest.get((String)this.buildURL(ddmDataProviderRequest, ddmRESTDataProviderSettings));
        if (StringUtil.startsWith((String)ddmRESTDataProviderSettings.url(), (String)"https")) {
            httpRequest.trustAllCerts(true);
        }
        if (Validator.isNotNull((String)ddmRESTDataProviderSettings.username())) {
            httpRequest.basicAuthentication(ddmRESTDataProviderSettings.username(), ddmRESTDataProviderSettings.password());
        }
        this.setRequestParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings, httpRequest);
        String cacheKey = this.getCacheKey(httpRequest);
        DDMRESTDataProviderResult ddmRESTDataProviderResult = (DDMRESTDataProviderResult)this._portalCache.get((Serializable)((Object)cacheKey));
        if (ddmRESTDataProviderResult != null && ddmRESTDataProviderSettings.cacheable()) {
            return ddmRESTDataProviderResult.getDDMDataProviderResponse();
        }
        HttpResponse httpResponse = httpRequest.send();
        DocumentContext documentContext = JsonPath.parse((String)httpResponse.bodyText());
        DDMDataProviderResponse ddmDataProviderResponse = this.createDDMDataProviderResponse(documentContext, ddmDataProviderRequest, ddmRESTDataProviderSettings);
        if (ddmRESTDataProviderSettings.cacheable()) {
            this._portalCache.put((Serializable)((Object)cacheKey), (Object)new DDMRESTDataProviderResult(ddmDataProviderResponse));
        }
        return ddmDataProviderResponse;
    }

    protected String getCacheKey(HttpRequest httpRequest) {
        return httpRequest.url();
    }

    protected Map<String, String> getPathParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        Map parameters = ddmDataProviderRequest.getParameters();
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        Matcher matcher = _pathParameterPattern.matcher(ddmRESTDataProviderSettings.url());
        while (matcher.find()) {
            String parameterName = matcher.group(1);
            if (!parameters.containsKey(parameterName)) continue;
            pathParameters.put(parameterName, (String)parameters.get(parameterName));
        }
        return pathParameters;
    }

    protected Map<String, String> getQueryParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings) {
        final Map<String, String> pathParameters = this.getPathParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings);
        return MapUtil.filter((Map)ddmDataProviderRequest.getParameters(), (PredicateFilter)new PredicateFilter<Map.Entry<String, String>>(){

            public boolean filter(Map.Entry<String, String> parameter) {
                return !pathParameters.containsKey(parameter.getKey());
            }
        });
    }

    protected String normalizePath(String path) {
        if (StringUtil.startsWith((String)path, (String)".") || StringUtil.startsWith((String)path, (String)"$")) {
            return path;
        }
        return ".".concat(path);
    }

    @Reference(unbind="-")
    protected void setMultiVMPool(MultiVMPool multiVMPool) {
        this._portalCache = multiVMPool.getPortalCache(DDMRESTDataProvider.class.getName());
    }

    protected void setRequestParameters(DDMDataProviderRequest ddmDataProviderRequest, DDMRESTDataProviderSettings ddmRESTDataProviderSettings, HttpRequest httpRequest) {
        if (ddmRESTDataProviderSettings.filterable()) {
            httpRequest.query(ddmRESTDataProviderSettings.filterParameterName(), ddmDataProviderRequest.getParameter("filterParameterValue"));
        }
        if (ddmRESTDataProviderSettings.pagination()) {
            httpRequest.query(ddmRESTDataProviderSettings.paginationEndParameterName(), ddmDataProviderRequest.getParameter("paginationStart"));
            httpRequest.query(ddmRESTDataProviderSettings.paginationEndParameterName(), ddmDataProviderRequest.getParameter("paginationEnd"));
        }
        httpRequest.query(this.getQueryParameters(ddmDataProviderRequest, ddmRESTDataProviderSettings));
    }

    private static class DDMRESTDataProviderResult
    implements Serializable {
        private final DDMDataProviderResponse _ddmDataProviderResponse;

        public DDMRESTDataProviderResult(DDMDataProviderResponse ddmDataProviderResponse) {
            this._ddmDataProviderResponse = ddmDataProviderResponse;
        }

        public DDMDataProviderResponse getDDMDataProviderResponse() {
            return this._ddmDataProviderResponse;
        }
    }
}

