/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProvider;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderContext;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.internal.rest.DDMRESTDataProviderSettings;
import com.liferay.portal.kernel.util.GetterUtil;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;

public class DDMDataProviderInvokeCommand
extends HystrixCommand<DDMDataProviderResponse> {
    private static final int _TIMEOUT_MAX = 30000;
    private static final int _TIMEOUT_MIN = 1000;
    private static final HystrixCommandGroupKey _hystrixCommandGroupKey = HystrixCommandGroupKey.Factory.asKey((String)"DDMDataProviderInvokeCommandGroup");
    private final DDMDataProvider _ddmDataProvider;
    private final DDMDataProviderRequest _ddmDataProviderRequest;

    public DDMDataProviderInvokeCommand(String ddmDataProviderInstanceName, DDMDataProvider ddmDataProvider, DDMDataProviderRequest ddmDataProviderRequest) {
        super(HystrixCommand.Setter.withGroupKey((HystrixCommandGroupKey)_hystrixCommandGroupKey).andCommandKey(HystrixCommandKey.Factory.asKey((String)("DDMDataProviderInvokeCommand#" + ddmDataProviderInstanceName))).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(DDMDataProviderInvokeCommand.getTimeout(ddmDataProviderRequest))));
        this._ddmDataProvider = ddmDataProvider;
        this._ddmDataProviderRequest = ddmDataProviderRequest;
    }

    protected static int getTimeout(DDMDataProviderRequest ddmDataProviderRequest) {
        DDMDataProviderContext ddmDataProviderContext = ddmDataProviderRequest.getDDMDataProviderContext();
        DDMRESTDataProviderSettings ddmRESTDataProviderSettings = (DDMRESTDataProviderSettings)ddmDataProviderContext.getSettingsInstance(DDMRESTDataProviderSettings.class);
        int timeout = GetterUtil.getInteger((String)ddmRESTDataProviderSettings.timeout());
        if (timeout >= 1000 && timeout <= 30000) {
            return timeout;
        }
        return 1000;
    }

    protected DDMDataProviderResponse run() throws Exception {
        return this._ddmDataProvider.getData(this._ddmDataProviderRequest);
    }
}

