/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider.internal.servlet;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderInvoker;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderRequest;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponse;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseOutput;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/dynamic-data-mapping-data-provider-paginator", "osgi.http.whiteboard.servlet.name=com.liferay.dynamic.data.mapping.data.provider.internal.servlet.DDMDataProviderPaginatorServlet", "osgi.http.whiteboard.servlet.pattern=/dynamic-data-mapping-data-provider-paginator/*"}, service={DDMDataProviderPaginatorServlet.class, Servlet.class})
public class DDMDataProviderPaginatorServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(DDMDataProviderPaginatorServlet.class);
    private static final long serialVersionUID = 1L;
    @Reference
    private DDMDataProviderInvoker _ddmDataProviderInvoker;
    @Reference
    private JSONFactory _jsonFactory;

    protected void addParametersFromRequest(DDMDataProviderRequest ddmDataProviderRequest, HttpServletRequest request) throws Exception {
        JSONObject inputParametersJSONObject = this.getInputParametersJSONObject(request);
        Iterator iterator = inputParametersJSONObject.keys();
        iterator.forEachRemaining(inputParameterName -> ddmDataProviderRequest.queryString(inputParameterName, inputParametersJSONObject.getString(inputParameterName)));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List<Map<String, String>> dataProviderResult = this.executeDataProvider(request, response);
        if (dataProviderResult == null) {
            response.sendError(400);
            return;
        }
        JSONSerializer jsonSerializer = this._jsonFactory.createJSONSerializer();
        response.setContentType("application/json");
        response.setStatus(200);
        ServletResponseUtil.write((HttpServletResponse)response, (String)jsonSerializer.serializeDeep(dataProviderResult));
    }

    protected List<Map<String, String>> executeDataProvider(HttpServletRequest request, HttpServletResponse response) {
        ArrayList<Map<String, String>> dataProviderResult;
        block5: {
            String dataProviderInstanceUUID = ParamUtil.getString((HttpServletRequest)request, (String)"dataProviderInstanceUUID");
            String outputParameterName = ParamUtil.getString((HttpServletRequest)request, (String)"outputParameterName");
            int start = ParamUtil.getInteger((HttpServletRequest)request, (String)"start");
            int end = ParamUtil.getInteger((HttpServletRequest)request, (String)"end");
            if (Validator.isNull((String)dataProviderInstanceUUID) || Validator.isNull((String)outputParameterName) || start < 0 || end < 0 || end < start || start == end) {
                return null;
            }
            dataProviderResult = new ArrayList<Map<String, String>>();
            try {
                DDMDataProviderRequest ddmDataProviderRequest = new DDMDataProviderRequest(dataProviderInstanceUUID, request);
                this.addParametersFromRequest(ddmDataProviderRequest, request);
                ddmDataProviderRequest.queryString("paginationStart", String.valueOf(start));
                ddmDataProviderRequest.queryString("paginationEnd", String.valueOf(end));
                DDMDataProviderResponse ddmDataProviderResponse = this._ddmDataProviderInvoker.invoke(ddmDataProviderRequest);
                DDMDataProviderResponseOutput ddmDataProviderResponseOutput = ddmDataProviderResponse.get(outputParameterName);
                if (ddmDataProviderResponseOutput == null) {
                    return dataProviderResult;
                }
                List keyValuePairs = (List)ddmDataProviderResponseOutput.getValue(List.class);
                for (KeyValuePair keyValuePair : keyValuePairs) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("label", keyValuePair.getValue());
                    result.put("value", keyValuePair.getKey());
                    dataProviderResult.add(result);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return dataProviderResult;
    }

    protected JSONObject getInputParametersJSONObject(HttpServletRequest request) throws JSONException {
        String inputParameters = ParamUtil.getString((HttpServletRequest)request, (String)"inputParameters");
        if (Validator.isNull((String)inputParameters)) {
            return this._jsonFactory.createJSONObject();
        }
        return this._jsonFactory.createJSONObject(inputParameters);
    }
}

