/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.change.tracking.internal.service;

import com.liferay.change.tracking.engine.CTEngineManager;
import com.liferay.change.tracking.engine.CTManager;
import com.liferay.change.tracking.model.CTEntryModel;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureVersionLocalServiceWrapper;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.Portal;
import java.util.Objects;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class CTDDMStructureVersionLocalServiceWrapper
extends DDMStructureVersionLocalServiceWrapper {
    private static final Log _log = LogFactoryUtil.getLog(CTDDMStructureVersionLocalServiceWrapper.class);
    @Reference
    private CTEngineManager _ctEngineManager;
    @Reference
    private CTManager _ctManager;
    @Reference
    private DDMStructureVersionLocalService _ddmStructureVersionLocalService;
    @Reference
    private Portal _portal;

    public CTDDMStructureVersionLocalServiceWrapper() {
        super(null);
    }

    public CTDDMStructureVersionLocalServiceWrapper(DDMStructureVersionLocalService ddmStructureVersionLocalService) {
        super(ddmStructureVersionLocalService);
    }

    public DDMStructureVersion getLatestStructureVersion(long structureId) throws PortalException {
        DDMStructureVersion latestDDMStructureVersion = super.getLatestStructureVersion(structureId);
        if (!this._isChangeTrackingEnabled(latestDDMStructureVersion) || this._ctManager.isModelUpdateInProgress()) {
            return latestDDMStructureVersion;
        }
        Optional ctEntryOptional = this._ctManager.getLatestModelChangeCTEntryOptional(latestDDMStructureVersion.getCompanyId(), PrincipalThreadLocal.getUserId(), structureId);
        return ctEntryOptional.map(CTEntryModel::getModelClassPK).map(arg_0 -> ((DDMStructureVersionLocalService)this._ddmStructureVersionLocalService).fetchDDMStructureVersion(arg_0)).orElse(latestDDMStructureVersion);
    }

    private boolean _isChangeTrackingEnabled(DDMStructureVersion ddmStructureVersion) {
        if (!this._ctEngineManager.isChangeTrackingEnabled(ddmStructureVersion.getCompanyId())) {
            return false;
        }
        DDMStructure ddmStructure = null;
        try {
            ddmStructure = ddmStructureVersion.getStructure();
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get dynamic data mapping structure " + ddmStructureVersion.getStructureId()), (Throwable)pe);
            }
            return false;
        }
        long journalClassNameId = this._portal.getClassNameId(JournalArticle.class);
        return ddmStructure.getClassNameId() == journalClassNameId && !Objects.equals(ddmStructure.getStructureKey(), "BASIC-WEB-CONTENT");
    }
}

