/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model;

import com.liferay.dynamic.data.mapping.model.DDMFormLayoutPage;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.petra.lang.HashUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class DDMFormLayout
implements Serializable {
    public static final String SETTINGS_MODE = "settings";
    public static final String SINGLE_PAGE_MODE = "single-page";
    public static final String TABBED_MODE = "tabbed";
    public static final String WIZARD_MODE = "wizard";
    private Set<Locale> _availableLocales = new LinkedHashSet<Locale>();
    private List<DDMFormLayoutPage> _ddmFormLayoutPages = new ArrayList<DDMFormLayoutPage>();
    private List<DDMFormRule> _ddmFormRules = new ArrayList<DDMFormRule>();
    private Locale _defaultLocale;
    private String _definitionSchemaVersion;
    private String _paginationMode;

    public DDMFormLayout() {
    }

    public DDMFormLayout(DDMFormLayout ddmFormLayout) {
        this._defaultLocale = ddmFormLayout._defaultLocale;
        this._paginationMode = ddmFormLayout._paginationMode;
        this._definitionSchemaVersion = ddmFormLayout._definitionSchemaVersion;
        for (DDMFormLayoutPage ddmFormLayoutPage : ddmFormLayout._ddmFormLayoutPages) {
            this.addDDMFormLayoutPage(new DDMFormLayoutPage(ddmFormLayoutPage));
        }
        for (DDMFormRule ddmFormRule : ddmFormLayout._ddmFormRules) {
            this.addDDMFormRule(new DDMFormRule(ddmFormRule));
        }
    }

    public void addDDMFormLayoutPage(DDMFormLayoutPage ddmFormLayoutPage) {
        this._ddmFormLayoutPages.add(ddmFormLayoutPage);
    }

    public void addDDMFormRule(DDMFormRule ddmFormRule) {
        this._ddmFormRules.add(ddmFormRule);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DDMFormLayout)) {
            return false;
        }
        DDMFormLayout ddmFormLayout = (DDMFormLayout)object;
        return Objects.equals(this._availableLocales, ddmFormLayout._availableLocales) && Objects.equals(this._ddmFormLayoutPages, ddmFormLayout._ddmFormLayoutPages) && Objects.equals(this._ddmFormRules, ddmFormLayout._ddmFormRules) && Objects.equals(this._defaultLocale, ddmFormLayout._defaultLocale) && Objects.equals(this._paginationMode, ddmFormLayout._paginationMode) && Objects.equals(this._definitionSchemaVersion, ddmFormLayout._definitionSchemaVersion);
    }

    public Set<Locale> getAvailableLocales() {
        return this._availableLocales;
    }

    public DDMFormLayoutPage getDDMFormLayoutPage(int index) {
        return this._ddmFormLayoutPages.get(index);
    }

    public List<DDMFormLayoutPage> getDDMFormLayoutPages() {
        return this._ddmFormLayoutPages;
    }

    public List<DDMFormRule> getDDMFormRules() {
        return this._ddmFormRules;
    }

    public Locale getDefaultLocale() {
        return this._defaultLocale;
    }

    public String getDefinitionSchemaVersion() {
        return this._definitionSchemaVersion;
    }

    public String getPaginationMode() {
        return this._paginationMode;
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._availableLocales);
        hash = HashUtil.hash((int)hash, this._ddmFormLayoutPages);
        hash = HashUtil.hash((int)hash, this._ddmFormRules);
        hash = HashUtil.hash((int)hash, (Object)this._defaultLocale);
        hash = HashUtil.hash((int)hash, (Object)this._paginationMode);
        return HashUtil.hash((int)hash, (Object)this._definitionSchemaVersion);
    }

    public void setAvailableLocales(Set<Locale> availableLocales) {
        this._availableLocales = availableLocales;
    }

    public void setDDMFormLayoutPages(List<DDMFormLayoutPage> ddmFormLayoutPages) {
        this._ddmFormLayoutPages = ddmFormLayoutPages;
    }

    public void setDDMFormRules(List<DDMFormRule> ddmFormRules) {
        this._ddmFormRules = ddmFormRules;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this._defaultLocale = defaultLocale;
    }

    public void setDefinitionSchemaVersion(String definitionSchemaVersion) {
        this._definitionSchemaVersion = definitionSchemaVersion;
    }

    public void setPaginationMode(String paginationMode) {
        this._paginationMode = paginationMode;
    }
}

