/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.model;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldRule;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DDMFormField
implements Serializable {
    private static final String _DATA_SOURCE_TYPE_MANUAL = "manual";
    private DDMForm _ddmForm;
    private final List<DDMFormFieldRule> _ddmFormFieldRules;
    private List<DDMFormField> _nestedDDMFormFields;
    private final Map<String, Object> _properties;

    public DDMFormField() {
        this._ddmFormFieldRules = new ArrayList<DDMFormFieldRule>();
        this._nestedDDMFormFields = new ArrayList<DDMFormField>();
        this._properties = new LinkedHashMap<String, Object>();
    }

    public DDMFormField(DDMFormField ddmFormField) {
        this._properties = new LinkedHashMap<String, Object>(ddmFormField._properties);
        this.setDDMFormFieldOptions(new DDMFormFieldOptions(ddmFormField.getDDMFormFieldOptions()));
        this._ddmFormFieldRules = new ArrayList<DDMFormFieldRule>(ddmFormField._ddmFormFieldRules.size());
        for (DDMFormFieldRule ddmFormFieldRule : ddmFormField._ddmFormFieldRules) {
            this.addDDMFormFieldRule(new DDMFormFieldRule(ddmFormFieldRule));
        }
        DDMFormFieldValidation ddmFormFieldValidation = ddmFormField.getDDMFormFieldValidation();
        if (ddmFormFieldValidation != null) {
            this.setDDMFormFieldValidation(new DDMFormFieldValidation(ddmFormFieldValidation));
        }
        this.setFieldReference(ddmFormField.getFieldReference());
        this.setLabel(new LocalizedValue(ddmFormField.getLabel()));
        this.setPredefinedValue(new LocalizedValue(ddmFormField.getPredefinedValue()));
        this.setStyle(new LocalizedValue(ddmFormField.getStyle()));
        this.setTip(new LocalizedValue(ddmFormField.getTip()));
        this._nestedDDMFormFields = new ArrayList<DDMFormField>(ddmFormField._nestedDDMFormFields.size());
        for (DDMFormField nestedDDMFormField : ddmFormField._nestedDDMFormFields) {
            this.addNestedDDMFormField(new DDMFormField(nestedDDMFormField));
        }
    }

    public DDMFormField(String name, String type) {
        this._ddmFormFieldRules = new ArrayList<DDMFormFieldRule>();
        this._nestedDDMFormFields = new ArrayList<DDMFormField>();
        this._properties = new LinkedHashMap<String, Object>();
        this.setName(name);
        this.setType(type);
        Locale locale = LocaleUtil.getDefault();
        this.setDDMFormFieldOptions(new DDMFormFieldOptions(locale));
        this.setFieldReference(name);
        this.setLabel(new LocalizedValue(locale));
        this.setPredefinedValue(new LocalizedValue(locale));
        this.setStyle(new LocalizedValue(locale));
        this.setTip(new LocalizedValue(locale));
    }

    @Deprecated
    public void addDDMFormFieldRule(DDMFormFieldRule ddmFormFieldRule) {
        this._ddmFormFieldRules.add(ddmFormFieldRule);
    }

    public void addNestedDDMFormField(DDMFormField nestedDDMFormField) {
        nestedDDMFormField.setDDMForm(this._ddmForm);
        this._nestedDDMFormFields.add(nestedDDMFormField);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DDMFormField)) {
            return false;
        }
        DDMFormField ddmFormField = (DDMFormField)object;
        return Objects.equals(this._properties, ddmFormField._properties) && Objects.equals(this._nestedDDMFormFields, ddmFormField._nestedDDMFormFields);
    }

    public String getDataSourceType() {
        Object propertyDataSourceType = this._properties.get("dataSourceType");
        if (propertyDataSourceType == null) {
            return _DATA_SOURCE_TYPE_MANUAL;
        }
        String dataSourceType = "";
        if (propertyDataSourceType instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)propertyDataSourceType;
            return GetterUtil.getString((Object)jsonArray.get(0), (String)_DATA_SOURCE_TYPE_MANUAL);
        }
        if (propertyDataSourceType instanceof String && (dataSourceType = (String)propertyDataSourceType).startsWith("[") && dataSourceType.endsWith("]")) {
            try {
                JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)dataSourceType);
                return GetterUtil.getString((Object)jsonArray.get(0), (String)_DATA_SOURCE_TYPE_MANUAL);
            }
            catch (JSONException jsonException) {
                return dataSourceType;
            }
        }
        return dataSourceType;
    }

    public String getDataType() {
        return MapUtil.getString(this._properties, (String)"dataType");
    }

    public DDMForm getDDMForm() {
        return this._ddmForm;
    }

    public DDMFormFieldOptions getDDMFormFieldOptions() {
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)this._properties.get("options");
        String dataSourceType = this.getDataSourceType();
        if (ddmFormFieldOptions != null && Validator.isNotNull((String)dataSourceType) && !dataSourceType.equals(_DATA_SOURCE_TYPE_MANUAL)) {
            Locale defaultLocale = ddmFormFieldOptions.getDefaultLocale();
            ddmFormFieldOptions = new DDMFormFieldOptions();
            ddmFormFieldOptions.setDefaultLocale(defaultLocale);
        }
        return ddmFormFieldOptions;
    }

    public DDMFormFieldValidation getDDMFormFieldValidation() {
        Object value = this._properties.get("validation");
        if (value instanceof DDMFormFieldValidation) {
            return (DDMFormFieldValidation)value;
        }
        return null;
    }

    public String getFieldNamespace() {
        return MapUtil.getString(this._properties, (String)"fieldNamespace");
    }

    public String getFieldReference() {
        return MapUtil.getString(this._properties, (String)"fieldReference");
    }

    public String getIndexType() {
        return MapUtil.getString(this._properties, (String)"indexType");
    }

    public LocalizedValue getLabel() {
        return (LocalizedValue)this._properties.get("label");
    }

    public String getName() {
        return MapUtil.getString(this._properties, (String)"name");
    }

    public List<DDMFormField> getNestedDDMFormFields() {
        return this._nestedDDMFormFields;
    }

    public Map<String, DDMFormField> getNestedDDMFormFieldsMap() {
        LinkedHashMap<String, DDMFormField> nestedDDMFormFieldsMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            nestedDDMFormFieldsMap.put(nestedDDMFormField.getName(), nestedDDMFormField);
            nestedDDMFormFieldsMap.putAll(nestedDDMFormField.getNestedDDMFormFieldsMap());
        }
        return nestedDDMFormFieldsMap;
    }

    public Map<String, DDMFormField> getNestedDDMFormFieldsReferencesMap() {
        LinkedHashMap<String, DDMFormField> nestedDDMFormFieldsReferencesMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            nestedDDMFormFieldsReferencesMap.put(nestedDDMFormField.getFieldReference(), nestedDDMFormField);
            nestedDDMFormFieldsReferencesMap.putAll(nestedDDMFormField.getNestedDDMFormFieldsReferencesMap());
        }
        return nestedDDMFormFieldsReferencesMap;
    }

    public Map<String, DDMFormField> getNontransientNestedDDMFormFieldsMap() {
        LinkedHashMap<String, DDMFormField> nestedDDMFormFieldsMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            if (!nestedDDMFormField.isTransient()) {
                nestedDDMFormFieldsMap.put(nestedDDMFormField.getName(), nestedDDMFormField);
            }
            nestedDDMFormFieldsMap.putAll(nestedDDMFormField.getNontransientNestedDDMFormFieldsMap());
        }
        return nestedDDMFormFieldsMap;
    }

    public Map<String, DDMFormField> getNontransientNestedDDMFormFieldsReferencesMap() {
        LinkedHashMap<String, DDMFormField> nestedDDMFormFieldsReferencesMap = new LinkedHashMap<String, DDMFormField>();
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            if (!nestedDDMFormField.isTransient()) {
                nestedDDMFormFieldsReferencesMap.put(nestedDDMFormField.getFieldReference(), nestedDDMFormField);
            }
            nestedDDMFormFieldsReferencesMap.putAll(nestedDDMFormField.getNontransientNestedDDMFormFieldsReferencesMap());
        }
        return nestedDDMFormFieldsReferencesMap;
    }

    public LocalizedValue getPredefinedValue() {
        return (LocalizedValue)this._properties.get("predefinedValue");
    }

    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    public LocalizedValue getStyle() {
        return (LocalizedValue)this._properties.get("style");
    }

    public LocalizedValue getTip() {
        return (LocalizedValue)this._properties.get("tip");
    }

    public String getType() {
        return MapUtil.getString(this._properties, (String)"type");
    }

    public String getVisibilityExpression() {
        return MapUtil.getString(this._properties, (String)"visibilityExpression");
    }

    public int hashCode() {
        int hash = HashUtil.hash((int)0, this._properties);
        return HashUtil.hash((int)hash, this._nestedDDMFormFields);
    }

    public boolean isLocalizable() {
        return MapUtil.getBoolean(this._properties, (String)"localizable");
    }

    public boolean isMultiple() {
        return MapUtil.getBoolean(this._properties, (String)"multiple");
    }

    public boolean isReadOnly() {
        return MapUtil.getBoolean(this._properties, (String)"readOnly");
    }

    public boolean isRepeatable() {
        return MapUtil.getBoolean(this._properties, (String)"repeatable");
    }

    public boolean isRequired() {
        return MapUtil.getBoolean(this._properties, (String)"required");
    }

    public boolean isShowLabel() {
        return MapUtil.getBoolean(this._properties, (String)"showLabel", (boolean)true);
    }

    public boolean isTransient() {
        return Validator.isNull((String)this.getDataType());
    }

    public void setDataType(String dataType) {
        this._properties.put("dataType", dataType);
    }

    public void setDDMForm(DDMForm ddmForm) {
        for (DDMFormField nestedDDMFormField : this._nestedDDMFormFields) {
            nestedDDMFormField.setDDMForm(ddmForm);
        }
        this._ddmForm = ddmForm;
    }

    public void setDDMFormFieldOptions(DDMFormFieldOptions ddmFormFieldOptions) {
        this._properties.put("options", ddmFormFieldOptions);
    }

    public void setDDMFormFieldValidation(DDMFormFieldValidation ddmFormFieldValidation) {
        this._properties.put("validation", ddmFormFieldValidation);
    }

    public void setFieldNamespace(String fieldNamespace) {
        this._properties.put("fieldNamespace", fieldNamespace);
    }

    public void setFieldReference(String fieldReference) {
        this._properties.put("fieldReference", fieldReference);
    }

    public void setIndexType(String indexType) {
        this._properties.put("indexType", indexType);
    }

    public void setLabel(LocalizedValue label) {
        this._properties.put("label", label);
    }

    public void setLocalizable(boolean localizable) {
        this._properties.put("localizable", localizable);
    }

    public void setMultiple(boolean multiple) {
        this._properties.put("multiple", multiple);
    }

    public void setName(String name) {
        this._properties.put("name", name);
    }

    public void setNestedDDMFormFields(List<DDMFormField> nestedDDMFormFields) {
        this._nestedDDMFormFields = nestedDDMFormFields;
    }

    public void setPredefinedValue(LocalizedValue predefinedValue) {
        this._properties.put("predefinedValue", predefinedValue);
    }

    public void setProperty(String name, Object value) {
        this._properties.put(name, value);
    }

    public void setReadOnly(boolean readOnly) {
        this._properties.put("readOnly", readOnly);
    }

    public void setRepeatable(boolean repeatable) {
        this._properties.put("repeatable", repeatable);
    }

    public void setRequired(boolean required) {
        this._properties.put("required", required);
    }

    public void setShowLabel(boolean showLabel) {
        this._properties.put("showLabel", showLabel);
    }

    public void setStyle(LocalizedValue style) {
        this._properties.put("style", style);
    }

    public void setTip(LocalizedValue tip) {
        this._properties.put("tip", tip);
    }

    public void setType(String type) {
        this._properties.put("type", type);
    }

    public void setVisibilityExpression(String visibilityExpression) {
        this._properties.put("visibilityExpression", visibilityExpression);
    }
}

