/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.field.type;

import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldRenderer;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldRenderingContext;
import com.liferay.petra.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.Validator;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;

public abstract class BaseDDMFormFieldRenderer
implements DDMFormFieldRenderer {
    public abstract String getTemplateLanguage();

    public abstract String getTemplateNamespace();

    public abstract TemplateResource getTemplateResource();

    @Override
    public String render(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) throws PortalException {
        Template template = TemplateManagerUtil.getTemplate((String)this.getTemplateLanguage(), (TemplateResource)this.getTemplateResource(), (boolean)false);
        template.put((Object)"namespace", (Object)this.getTemplateNamespace());
        template.put((Object)"render_strict", (Object)Boolean.FALSE);
        this.populateRequiredContext(template, ddmFormField, ddmFormFieldRenderingContext);
        this.populateOptionalContext(template, ddmFormField, ddmFormFieldRenderingContext);
        return this.render(template);
    }

    protected TemplateResource getTemplateResource(String templatePath) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL templateURL = classLoader.getResource(templatePath);
        return new URLTemplateResource(templateURL.getPath(), templateURL);
    }

    protected String getValueString(Value value, Locale locale) {
        if (value != null) {
            return value.getString(locale);
        }
        return "";
    }

    protected void populateOptionalContext(Template template, DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
    }

    protected void populateRequiredContext(Template template, DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        Locale locale = ddmFormFieldRenderingContext.getLocale();
        String childElementsHTML = ddmFormFieldRenderingContext.getChildElementsHTML();
        if (Validator.isNotNull((String)childElementsHTML)) {
            template.put((Object)"childElementsHTML", (Object)childElementsHTML);
        }
        template.put((Object)"dir", (Object)LanguageUtil.get((Locale)locale, (String)"lang.dir"));
        template.put((Object)"label", (Object)ddmFormFieldRenderingContext.getLabel());
        template.put((Object)"name", (Object)ddmFormFieldRenderingContext.getName());
        template.put((Object)"readOnly", (Object)this._isReadOnly(ddmFormField, ddmFormFieldRenderingContext));
        template.put((Object)"required", (Object)ddmFormFieldRenderingContext.isRequired());
        template.put((Object)"showLabel", (Object)ddmFormField.isShowLabel());
        template.put((Object)"tip", (Object)ddmFormFieldRenderingContext.getTip());
        template.put((Object)"value", (Object)ddmFormFieldRenderingContext.getValue());
        template.put((Object)"visible", (Object)ddmFormFieldRenderingContext.isVisible());
    }

    protected String render(Template template) throws PortalException {
        UnsyncStringWriter writer = new UnsyncStringWriter();
        template.processTemplate((Writer)writer);
        return writer.toString();
    }

    private boolean _isReadOnly(DDMFormField ddmFormField, DDMFormFieldRenderingContext ddmFormFieldRenderingContext) {
        return ddmFormFieldRenderingContext.isReadOnly() || ddmFormField.isReadOnly();
    }
}

