/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.util.DDMDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DDMDisplayRegistry.class})
@ProviderType
public class DDMDisplayRegistry {
    private final Map<String, DDMDisplay> _ddmDisplays = new ConcurrentHashMap<String, DDMDisplay>();

    public DDMDisplay getDDMDisplay(String portletId) {
        return this._getDDMDisplay(portletId);
    }

    public List<DDMDisplay> getDDMDisplays() {
        return this._getDDMDisplays();
    }

    public String[] getPortletIds() {
        return this._getPortletIds();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setDDMDisplay(DDMDisplay ddmDisplay) {
        this._ddmDisplays.put(ddmDisplay.getPortletId(), ddmDisplay);
    }

    protected void unsetDDMDisplay(DDMDisplay ddmDisplay) {
        this._ddmDisplays.remove(ddmDisplay.getPortletId());
    }

    private DDMDisplay _getDDMDisplay(String portletId) {
        return this._ddmDisplays.get(portletId);
    }

    private List<DDMDisplay> _getDDMDisplays() {
        return ListUtil.fromMapValues(this._ddmDisplays);
    }

    private String[] _getPortletIds() {
        Set<String> portletIds = this._ddmDisplays.keySet();
        return portletIds.toArray(new String[0]);
    }
}

