/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.data.provider;

import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseOutput;
import com.liferay.dynamic.data.mapping.data.provider.DDMDataProviderResponseStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DDMDataProviderResponse {
    private final Map<String, DDMDataProviderResponseOutput> _dataMap = new HashMap<String, DDMDataProviderResponseOutput>();
    private final Status _status;

    public static DDMDataProviderResponse error(Status status) {
        return new DDMDataProviderResponse(status, Collections.emptyList());
    }

    public static DDMDataProviderResponse of(DDMDataProviderResponseOutput ... ddmDataProviderResponseOutputs) {
        return new DDMDataProviderResponse(Status.OK, Arrays.asList(ddmDataProviderResponseOutputs));
    }

    public DDMDataProviderResponseOutput get(String name) {
        return this._dataMap.get(name);
    }

    public Map<String, DDMDataProviderResponseOutput> getDataMap() {
        return Collections.unmodifiableMap(this._dataMap);
    }

    public Status getStatus() {
        return this._status;
    }

    public int size() {
        return this._dataMap.size();
    }

    private DDMDataProviderResponse(Status status, List<DDMDataProviderResponseOutput> ddmDataProviderResponseOutputs) {
        this._status = status;
        ddmDataProviderResponseOutputs.forEach(ddmDataProviderResponseOutput -> this._dataMap.put(ddmDataProviderResponseOutput.getName(), (DDMDataProviderResponseOutput)ddmDataProviderResponseOutput));
    }

    public static enum Status {
        OK,
        SERVICE_UNAVAILABLE,
        SHORTCIRCUIT,
        TIMEOUT,
        UNAUTHORIZED,
        UNKNOWN_ERROR;


        public static Status valueOf(DDMDataProviderResponseStatus ddmDataProviderResponseStatus) {
            if (ddmDataProviderResponseStatus == DDMDataProviderResponseStatus.OK) {
                return OK;
            }
            if (ddmDataProviderResponseStatus == DDMDataProviderResponseStatus.SERVICE_UNAVAILABLE) {
                return SERVICE_UNAVAILABLE;
            }
            if (ddmDataProviderResponseStatus == DDMDataProviderResponseStatus.SHORT_CIRCUIT) {
                return SHORTCIRCUIT;
            }
            if (ddmDataProviderResponseStatus == DDMDataProviderResponseStatus.TIMEOUT) {
                return TIMEOUT;
            }
            if (ddmDataProviderResponseStatus == DDMDataProviderResponseStatus.UNAUTHORIZED) {
                return UNAUTHORIZED;
            }
            return UNKNOWN_ERROR;
        }
    }

    public static class Builder {
        private final List<DDMDataProviderResponseOutput> _ddmDataProviderResponseOutputs = new ArrayList<DDMDataProviderResponseOutput>();
        private Status _status = Status.OK;

        public static Builder newBuilder() {
            return new Builder();
        }

        public DDMDataProviderResponse build() {
            return new DDMDataProviderResponse(this._status, this._ddmDataProviderResponseOutputs);
        }

        public Builder withOutput(String name, Object value) {
            this._ddmDataProviderResponseOutputs.add(DDMDataProviderResponseOutput.of(name, null, value));
            return this;
        }

        public Builder withOutput(String name, String type, Object value) {
            this._ddmDataProviderResponseOutputs.add(DDMDataProviderResponseOutput.of(name, type, value));
            return this;
        }

        public Builder withStatus(DDMDataProviderResponseStatus ddmDataProviderResponseStatus) {
            this._status = Status.valueOf(ddmDataProviderResponseStatus);
            return this;
        }

        private Builder() {
        }
    }
}

