/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.FieldConstants;
import com.liferay.dynamic.data.mapping.util.DDMFormFactoryHelper;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldFactoryHelper;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DDMFormInstanceFactoryHelper {
    private final DDMForm _ddmForm;
    private final Map<String, String> _ddmFormFieldMethodNameMap = new HashMap<String, String>();
    private final Map<String, List<DDMFormFieldValue>> _ddmFormFieldValuesMap;
    private final Locale _locale;

    public DDMFormInstanceFactoryHelper(Class<?> clazz, DDMFormValues ddmFormValues, Locale locale) {
        DDMForm ddmForm;
        this._locale = locale;
        this.setDDMFormFieldNameMethodMap(clazz);
        this._ddmForm = ddmForm = ddmFormValues.getDDMForm();
        this._ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (DDMFormField ddmFormField : this._ddmForm.getDDMFormFields()) {
            String methodName = this._ddmFormFieldMethodNameMap.get(ddmFormField.getName());
            Object value = null;
            List<DDMFormFieldValue> ddmFormFieldValues = this._ddmFormFieldValuesMap.get(ddmFormField.getName());
            value = ddmFormField.isRepeatable() ? this.toArrayValue(ddmFormField, ddmFormFieldValues) : this.toSimpleValue(ddmFormField, ddmFormFieldValues.get(0));
            properties.put(methodName, value);
        }
        return properties;
    }

    protected void setDDMFormFieldNameMethodMap(Class<?> clazz) {
        DDMFormFactoryHelper ddmFormFactoryHelper = new DDMFormFactoryHelper(clazz);
        for (Method method : ddmFormFactoryHelper.getDDMFormFieldMethods()) {
            DDMFormFieldFactoryHelper ddmFormFieldFactoryHelper = new DDMFormFieldFactoryHelper(method);
            this._ddmFormFieldMethodNameMap.put(ddmFormFieldFactoryHelper.getDDMFormFieldName(), method.getName());
        }
    }

    protected Object toArrayValue(DDMFormField ddmFormField, List<DDMFormFieldValue> ddmFormFieldValues) {
        ArrayList<Serializable> values = new ArrayList<Serializable>();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            Serializable value = this.toSimpleValue(ddmFormField, ddmFormFieldValue);
            values.add(value);
        }
        return FieldConstants.getSerializable(ddmFormField.getDataType(), values);
    }

    protected Serializable toSimpleValue(DDMFormField ddmFormField, DDMFormFieldValue ddmFormFieldValue) {
        Value value = ddmFormFieldValue.getValue();
        return FieldConstants.getSerializable(ddmFormField.getDataType(), value.getString(this._locale));
    }
}

