/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldFactoryHelper;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DDMFormFactoryHelper {
    private static final Class<? extends Annotation> _DDM_FORM_FIELD_ANNOTATION = com.liferay.dynamic.data.mapping.annotations.DDMFormField.class;
    private final Set<Locale> _availableLocales;
    private final Class<?> _clazz;
    private final com.liferay.dynamic.data.mapping.annotations.DDMForm _ddmForm;
    private final Locale _defaultLocale;

    public DDMFormFactoryHelper(Class<?> clazz) {
        this._clazz = clazz;
        this._ddmForm = clazz.getAnnotation(com.liferay.dynamic.data.mapping.annotations.DDMForm.class);
        this._availableLocales = this.getAvailableLocales();
        this._defaultLocale = this.getDefaultLocale();
    }

    public DDMForm createDDMForm() {
        DDMForm ddmForm = new DDMForm();
        ddmForm.setAvailableLocales(this._availableLocales);
        ddmForm.setDefaultLocale(this._defaultLocale);
        ddmForm.setDDMFormFields(this.getDDMFormFields());
        return ddmForm;
    }

    protected void collectDDMFormFieldMethodsMap(Class<?> clazz, Map<String, Method> methodsMap) {
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.collectDDMFormFieldMethodsMap(clazz2, methodsMap);
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
            if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(_DDM_FORM_FIELD_ANNOTATION)) continue;
            methodsMap.put(((Method)genericDeclaration).getName(), (Method)genericDeclaration);
        }
    }

    protected Set<Locale> getAvailableLocales() {
        if (Validator.isNull((String)this._ddmForm.availableLanguageIds())) {
            Locale defaultLocale = this.getDefaultLocale();
            return SetUtil.fromArray((Object[])new Locale[]{defaultLocale});
        }
        TreeSet<Locale> availableLocales = new TreeSet<Locale>();
        for (String availableLanguageId : StringUtil.split((String)this._ddmForm.availableLanguageIds())) {
            availableLocales.add(LocaleUtil.fromLanguageId((String)availableLanguageId));
        }
        return availableLocales;
    }

    protected Collection<Method> getDDMFormFieldMethods() {
        HashMap<String, Method> methodsMap = new HashMap<String, Method>();
        this.collectDDMFormFieldMethodsMap(this._clazz, methodsMap);
        return methodsMap.values();
    }

    protected List<DDMFormField> getDDMFormFields() {
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (Method method : this.getDDMFormFieldMethods()) {
            DDMFormFieldFactoryHelper ddmFormFieldFactoryHelper = new DDMFormFieldFactoryHelper(method);
            ddmFormFieldFactoryHelper.setAvailableLocales(this._availableLocales);
            ddmFormFieldFactoryHelper.setDefaultLocale(this._defaultLocale);
            ddmFormFields.add(ddmFormFieldFactoryHelper.createDDMFormField());
        }
        return ddmFormFields;
    }

    protected Locale getDefaultLocale() {
        if (Validator.isNull((String)this._ddmForm.defaultLanguageId())) {
            Locale defaultLocale = LocaleThreadLocal.getThemeDisplayLocale();
            if (defaultLocale == null) {
                defaultLocale = LocaleUtil.getDefault();
            }
            return defaultLocale;
        }
        return LocaleUtil.fromLanguageId((String)this._ddmForm.defaultLanguageId());
    }
}

