/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.model;

import java.io.Serializable;

import java.util.Locale;
import java.util.Map;
import java.util.Set;

/**
 * @author Marcellus Tavares
 */
public interface Value extends Serializable {

	public void addString(Locale locale, String value);

	public Set<Locale> getAvailableLocales();

	public Locale getDefaultLocale();

	public String getString(Locale locale);

	public Map<Locale, String> getValues();

	public boolean isLocalized();

	public void removeLocale(Locale locale);

	public void setDefaultLocale(Locale defaultLocale);

}