/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.template;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.util.Date;

public class DDMTemplateResource
implements TemplateResource {
    private DDMTemplate _ddmTemplate;
    private String _ddmTemplateKey;

    public DDMTemplateResource() {
    }

    public DDMTemplateResource(String ddmTemplateKey, DDMTemplate ddmTemplate) {
        if (Validator.isNull((String)ddmTemplateKey)) {
            throw new IllegalArgumentException("DDM Template Key is null");
        }
        if (ddmTemplate == null) {
            throw new IllegalArgumentException("DDM template is null");
        }
        this._ddmTemplateKey = ddmTemplateKey;
        this._ddmTemplate = ddmTemplate;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DDMTemplateResource)) {
            return false;
        }
        DDMTemplateResource ddmTemplateResource = (DDMTemplateResource)object;
        return this._ddmTemplateKey.equals(ddmTemplateResource._ddmTemplateKey) && this._ddmTemplate.equals(ddmTemplateResource._ddmTemplate);
    }

    public long getLastModified() {
        Date modifiedDate = this._ddmTemplate.getModifiedDate();
        return modifiedDate.getTime();
    }

    public Reader getReader() {
        return new UnsyncStringReader(this._ddmTemplate.getScript());
    }

    public String getTemplateId() {
        return this._ddmTemplateKey;
    }

    public int hashCode() {
        return this._ddmTemplateKey.hashCode() * 11 + this._ddmTemplate.hashCode();
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        long ddmTemplateId = objectInput.readLong();
        try {
            this._ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate(ddmTemplateId);
        }
        catch (Exception exception) {
            throw new IOException("Unable to retrieve ddm template with ID " + ddmTemplateId, exception);
        }
        this._ddmTemplateKey = objectInput.readUTF();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this._ddmTemplate.getTemplateId());
        objectOutput.writeUTF(this._ddmTemplateKey);
    }
}

