/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.dynamic.data.mapping.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the DDMFieldAttribute service. Represents a row in the &quot;DDMFieldAttribute&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.dynamic.data.mapping.model.impl.DDMFieldAttributeModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.dynamic.data.mapping.model.impl.DDMFieldAttributeImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DDMFieldAttribute
 * @generated
 */
@ProviderType
public interface DDMFieldAttributeModel
	extends BaseModel<DDMFieldAttribute>, CTModel<DDMFieldAttribute>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a ddm field attribute model instance should use the {@link DDMFieldAttribute} interface instead.
	 */

	/**
	 * Returns the primary key of this ddm field attribute.
	 *
	 * @return the primary key of this ddm field attribute
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this ddm field attribute.
	 *
	 * @param primaryKey the primary key of this ddm field attribute
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this ddm field attribute.
	 *
	 * @return the mvcc version of this ddm field attribute
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this ddm field attribute.
	 *
	 * @param mvccVersion the mvcc version of this ddm field attribute
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this ddm field attribute.
	 *
	 * @return the ct collection ID of this ddm field attribute
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this ddm field attribute.
	 *
	 * @param ctCollectionId the ct collection ID of this ddm field attribute
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the field attribute ID of this ddm field attribute.
	 *
	 * @return the field attribute ID of this ddm field attribute
	 */
	public long getFieldAttributeId();

	/**
	 * Sets the field attribute ID of this ddm field attribute.
	 *
	 * @param fieldAttributeId the field attribute ID of this ddm field attribute
	 */
	public void setFieldAttributeId(long fieldAttributeId);

	/**
	 * Returns the company ID of this ddm field attribute.
	 *
	 * @return the company ID of this ddm field attribute
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this ddm field attribute.
	 *
	 * @param companyId the company ID of this ddm field attribute
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the field ID of this ddm field attribute.
	 *
	 * @return the field ID of this ddm field attribute
	 */
	public long getFieldId();

	/**
	 * Sets the field ID of this ddm field attribute.
	 *
	 * @param fieldId the field ID of this ddm field attribute
	 */
	public void setFieldId(long fieldId);

	/**
	 * Returns the storage ID of this ddm field attribute.
	 *
	 * @return the storage ID of this ddm field attribute
	 */
	public long getStorageId();

	/**
	 * Sets the storage ID of this ddm field attribute.
	 *
	 * @param storageId the storage ID of this ddm field attribute
	 */
	public void setStorageId(long storageId);

	/**
	 * Returns the attribute name of this ddm field attribute.
	 *
	 * @return the attribute name of this ddm field attribute
	 */
	@AutoEscape
	public String getAttributeName();

	/**
	 * Sets the attribute name of this ddm field attribute.
	 *
	 * @param attributeName the attribute name of this ddm field attribute
	 */
	public void setAttributeName(String attributeName);

	/**
	 * Returns the language ID of this ddm field attribute.
	 *
	 * @return the language ID of this ddm field attribute
	 */
	@AutoEscape
	public String getLanguageId();

	/**
	 * Sets the language ID of this ddm field attribute.
	 *
	 * @param languageId the language ID of this ddm field attribute
	 */
	public void setLanguageId(String languageId);

	/**
	 * Returns the large attribute value of this ddm field attribute.
	 *
	 * @return the large attribute value of this ddm field attribute
	 */
	@AutoEscape
	public String getLargeAttributeValue();

	/**
	 * Sets the large attribute value of this ddm field attribute.
	 *
	 * @param largeAttributeValue the large attribute value of this ddm field attribute
	 */
	public void setLargeAttributeValue(String largeAttributeValue);

	/**
	 * Returns the small attribute value of this ddm field attribute.
	 *
	 * @return the small attribute value of this ddm field attribute
	 */
	@AutoEscape
	public String getSmallAttributeValue();

	/**
	 * Sets the small attribute value of this ddm field attribute.
	 *
	 * @param smallAttributeValue the small attribute value of this ddm field attribute
	 */
	public void setSmallAttributeValue(String smallAttributeValue);

	@Override
	public DDMFieldAttribute cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}