/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.form.validation.util;

import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class DateParameterUtil {
    private static final String _PATTERN = "yyyy-MM-dd";
    private static final Log _log = LogFactoryUtil.getLog(DateParameterUtil.class);

    public static LocalDate getLocalDate(String dateString) {
        if (Validator.isNull((String)dateString)) {
            return null;
        }
        try {
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_PATTERN);
            return LocalDate.parse(dateFormat.format(dateFormat.parse(dateString)), DateTimeFormatter.ofPattern(_PATTERN));
        }
        catch (ParseException parseException) {
            _log.error((Throwable)parseException);
            return null;
        }
    }

    public static LocalDateTime getLocalDateTime(String dateTimeString) {
        if (Validator.isNull((String)dateTimeString)) {
            return null;
        }
        return LocalDateTime.parse(dateTimeString, DateTimeFormatter.ofPattern("yyyy-MM-dd H:mm"));
    }

    public static String getParameter(DDMFormValues ddmFormValues, String key, String parameter, String timeZoneId) {
        JSONObject jsonObject;
        try {
            jsonObject = JSONFactoryUtil.createJSONObject((String)parameter);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return "";
        }
        LocalDate localDate = DateParameterUtil._getComparisonLocalDate(DateParameterUtil._getCurrentLocalDate(timeZoneId), ddmFormValues, jsonObject.getJSONObject(key));
        if (localDate == null) {
            return "";
        }
        return localDate.toString();
    }

    private static LocalDate _getComparisonLocalDate(LocalDate currentLocalDate, DDMFormValues ddmFormValues, JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String type = jsonObject.getString("type");
        if (StringUtil.equals((String)type, (String)"customDate")) {
            if (StringUtil.equals((String)jsonObject.getString("date"), (String)"responseDate")) {
                return DateParameterUtil._getCustomLocalDate(currentLocalDate, jsonObject.getInt("quantity"), jsonObject.getString("unit"));
            }
            if (StringUtil.equals((String)jsonObject.getString("date"), (String)"dateField")) {
                return DateParameterUtil._getCustomLocalDate(DateParameterUtil.getLocalDate(DateParameterUtil._getDateFieldValue(jsonObject.getString("dateFieldName"), ddmFormValues)), jsonObject.getInt("quantity"), jsonObject.getString("unit"));
            }
        } else {
            if (StringUtil.equals((String)type, (String)"dateField")) {
                return DateParameterUtil.getLocalDate(DateParameterUtil._getDateFieldValue(jsonObject.getString("dateFieldName"), ddmFormValues));
            }
            if (StringUtil.equals((String)type, (String)"responseDate")) {
                return currentLocalDate;
            }
        }
        return null;
    }

    private static LocalDate _getCurrentLocalDate(String timeZoneId) {
        if (Validator.isNull((String)timeZoneId)) {
            TimeZone timeZone = TimeZoneUtil.getDefault();
            timeZoneId = timeZone.getID();
        }
        return LocalDate.now(ZoneId.of(timeZoneId));
    }

    private static LocalDate _getCustomLocalDate(LocalDate localDate, int quantity, String unit) {
        if (localDate == null) {
            return null;
        }
        if (StringUtil.equals((String)unit, (String)"days")) {
            return localDate.plusDays(quantity);
        }
        if (StringUtil.equals((String)unit, (String)"months")) {
            return localDate.plusMonths(quantity);
        }
        if (StringUtil.equals((String)unit, (String)"years")) {
            return localDate.plusYears(quantity);
        }
        return null;
    }

    private static String _getDateFieldValue(String dateFieldName, DDMFormValues ddmFormValues) {
        if (ddmFormValues == null) {
            return null;
        }
        Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(true);
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(dateFieldName);
        if (ListUtil.isNotEmpty(ddmFormFieldValues)) {
            DDMFormFieldValue ddmFormFieldValue = ddmFormFieldValues.get(0);
            Value value = ddmFormFieldValue.getValue();
            return value.getString(ddmFormValues.getDefaultLocale());
        }
        return null;
    }
}

