/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.storage.constants;

import com.liferay.dynamic.data.mapping.util.NumberUtil;
import com.liferay.dynamic.data.mapping.util.NumericDDMFormFieldUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class FieldConstants {
    public static final String BOOLEAN = "boolean";
    public static final String DATA_TYPE = "dataType";
    public static final String DATE = "date";
    public static final String DOCUMENT_LIBRARY = "document-library";
    public static final String DOUBLE = "double";
    public static final String EDITABLE = "editable";
    public static final String FLOAT = "float";
    public static final String HTML = "html";
    public static final String IMAGE = "image";
    public static final String INTEGER = "integer";
    public static final String LABEL = "label";
    public static final String LONG = "long";
    public static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String PREDEFINED_VALUE = "predefinedValue";
    public static final String PRIVATE = "private";
    public static final String REQUIRED = "required";
    public static final String SHORT = "short";
    public static final String SHOW = "showLabel";
    public static final String SORTABLE = "sortable";
    public static final String STRING = "string";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    private static final Log _log = LogFactoryUtil.getLog(FieldConstants.class);

    public static Serializable getSerializable(Locale defaultLocale, Locale locale, String type, String value) {
        Serializable serializable = null;
        if (FieldConstants.isNumericType(type)) {
            DecimalFormat decimalFormat = null;
            decimalFormat = locale.equals(LocaleUtil.ROOT) ? NumericDDMFormFieldUtil.getDecimalFormat(defaultLocale) : NumericDDMFormFieldUtil.getDecimalFormat(locale);
            if (type.equals(DOUBLE) || type.equals(FLOAT)) {
                decimalFormat.setMinimumFractionDigits(1);
            }
            value = GetterUtil.getString((String)value);
            try {
                String decimalPart;
                Number number = decimalFormat.parse(GetterUtil.getString((String)value));
                String formattedValue = String.valueOf(number);
                if (number.doubleValue() > 2.147483647E9) {
                    return value;
                }
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                String[] valueParts = StringUtil.split((String)value, (char)decimalFormatSymbols.getDecimalSeparator());
                if (valueParts.length > 1 && (decimalPart = valueParts[1]).length() > 1 && StringUtil.endsWith((String)decimalPart, (String)"0")) {
                    return value;
                }
                if (!NumberUtil.hasDecimalSeparator(formattedValue) && NumberUtil.hasDecimalSeparator(value)) {
                    formattedValue = StringBundler.concat((String[])new String[]{formattedValue, ".", value.substring(NumberUtil.getDecimalSeparatorIndex(value) + 1)});
                }
                serializable = FieldConstants.getSerializable(type, formattedValue);
            }
            catch (ParseException parseException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)parseException);
                }
                serializable = FieldConstants.getSerializable(type, value);
            }
        } else {
            serializable = FieldConstants.getSerializable(type, value);
        }
        return serializable;
    }

    public static Serializable getSerializable(String type, List<Serializable> values) {
        if (Validator.isNull((String)type)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid type " + type));
            }
            return values.toArray(new String[0]);
        }
        if (FieldConstants.isNumericType(type)) {
            values.removeAll(Collections.singleton(""));
        }
        if (type.equals(BOOLEAN)) {
            return values.toArray(new Boolean[0]);
        }
        if (type.equals(DATE)) {
            return values.toArray(new String[0]);
        }
        if (type.equals(DOUBLE) || type.equals(INTEGER)) {
            return ListUtil.toArray(values, (Accessor)new Accessor<Object, Number>(){

                public Number get(Object value) {
                    return GetterUtil.getNumber((Object)value);
                }

                public Class<Number> getAttributeClass() {
                    return Number.class;
                }

                public Class<Object> getTypeClass() {
                    return Object.class;
                }
            });
        }
        if (type.equals(FLOAT)) {
            return values.toArray(new Float[0]);
        }
        if (type.equals(LONG)) {
            return values.toArray(new Long[0]);
        }
        if (type.equals(NUMBER)) {
            return values.toArray(new Number[0]);
        }
        if (type.equals(SHORT)) {
            return values.toArray(new Short[0]);
        }
        return values.toArray(new String[0]);
    }

    public static Serializable getSerializable(String type, String value) {
        if (Validator.isNull((String)type)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Invalid type " + type));
            }
            return value;
        }
        if (FieldConstants.isNumericType(type) && Validator.isNull((String)value)) {
            return "";
        }
        if (type.equals(BOOLEAN)) {
            return Boolean.valueOf(GetterUtil.getBoolean((String)value));
        }
        if (type.equals(DATE) && Validator.isNotNull((String)value)) {
            return value;
        }
        if (type.equals(DOUBLE)) {
            if (!NumberUtil.hasDecimalSeparator(value)) {
                return Integer.valueOf(GetterUtil.getInteger((String)value));
            }
            return Double.valueOf(GetterUtil.getDouble((String)value));
        }
        if (type.equals(FLOAT)) {
            if (!NumberUtil.hasDecimalSeparator(value)) {
                return Integer.valueOf(GetterUtil.getInteger((String)value));
            }
            return Float.valueOf(GetterUtil.getFloat((String)value));
        }
        if (type.equals(INTEGER)) {
            return Integer.valueOf(GetterUtil.getInteger((String)value));
        }
        if (type.equals(LONG)) {
            return Long.valueOf(GetterUtil.getLong((String)value));
        }
        if (type.equals(NUMBER)) {
            return GetterUtil.getNumber((String)value);
        }
        if (type.equals(SHORT)) {
            return Short.valueOf(GetterUtil.getShort((String)value));
        }
        return value;
    }

    public static boolean isNumericType(String type) {
        return type.equals(DOUBLE) || type.equals(FLOAT) || type.equals(INTEGER) || type.equals(LONG) || type.equals(NUMBER) || type.equals(SHORT);
    }
}

