/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.util.comparator;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.util.CollatorUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import java.text.Collator;
import java.util.Locale;

public class StructureNameComparator
extends OrderByComparator<DDMStructure> {
    public static final String ORDER_BY_ASC = "DDMStructure.name ASC";
    public static final String ORDER_BY_DESC = "DDMStructure.name DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"name"};
    private final boolean _ascending;
    private final Collator _collator;
    private final Locale _locale;

    public StructureNameComparator() {
        this(false);
    }

    public StructureNameComparator(boolean ascending) {
        this(ascending, LocaleUtil.getDefault());
    }

    public StructureNameComparator(boolean ascending, Locale locale) {
        this._ascending = ascending;
        this._locale = locale;
        this._collator = CollatorUtil.getInstance((Locale)locale);
    }

    public int compare(DDMStructure ddmStructure1, DDMStructure ddmStructure2) {
        String name1 = StringUtil.toLowerCase((String)ddmStructure1.getName(this._locale));
        String name2 = StringUtil.toLowerCase((String)ddmStructure2.getName(this._locale));
        int value = this._collator.compare(name1, name2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }
}

