/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.mapping.validator;

import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import java.util.Locale;

public class DDMFormValuesValidationException
extends StorageException {
    public DDMFormValuesValidationException() {
    }

    public DDMFormValuesValidationException(String msg) {
        super(msg);
    }

    public DDMFormValuesValidationException(String msg, Throwable throwable) {
        super(msg, throwable);
    }

    public DDMFormValuesValidationException(Throwable throwable) {
        super(throwable);
    }

    public static class RequiredValue
    extends DDMFormValuesValidationException {
        private final LocalizedValue _fieldLabel;
        private final String _fieldName;

        public RequiredValue(LocalizedValue fieldLabel, String fieldName) {
            super(String.format("No value defined for field name", fieldName));
            this._fieldLabel = fieldLabel;
            this._fieldName = fieldName;
        }

        public RequiredValue(String fieldName) {
            this(null, fieldName);
        }

        public LocalizedValue getFieldLabel() {
            return this._fieldLabel;
        }

        public String getFieldLabelValue(Locale locale) {
            if (this._fieldLabel == null) {
                return "";
            }
            return this._fieldLabel.getString(locale);
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidValuesSize
    extends DDMFormValuesValidationException {
        private final LocalizedValue _fieldLabel;
        private String _fieldName;

        public MustSetValidValuesSize(LocalizedValue fieldLabel, String fieldName) {
            super(String.format("Incorrect number of values set for field name %s", fieldName));
            this._fieldLabel = fieldLabel;
            this._fieldName = fieldName;
        }

        public MustSetValidValuesSize(String fieldName) {
            this(null, fieldName);
        }

        public LocalizedValue getFieldLabel() {
            return this._fieldLabel;
        }

        public String getFieldLabelValue(Locale locale) {
            if (this._fieldLabel == null) {
                return "";
            }
            return this._fieldLabel.getString(locale);
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidValue
    extends DDMFormValuesValidationException {
        private LocalizedValue _fieldLabel;
        private String _fieldName;

        public MustSetValidValue(LocalizedValue fieldLabel, String fieldName) {
            super(String.format("Invalid value set for field name %s", fieldName));
            this._fieldLabel = fieldLabel;
            this._fieldName = fieldName;
        }

        public MustSetValidValue(String fieldName) {
            this(null, fieldName);
        }

        public MustSetValidValue(String fieldName, Throwable throwable) {
            super(String.format("Invalid value set for field name %s", fieldName), throwable);
            this._fieldName = fieldName;
        }

        public LocalizedValue getFieldLabel() {
            return this._fieldLabel;
        }

        public String getFieldLabelValue(Locale locale) {
            if (this._fieldLabel == null) {
                return "";
            }
            return this._fieldLabel.getString(locale);
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidField
    extends DDMFormValuesValidationException {
        private final LocalizedValue _fieldLabel;
        private String _fieldName;

        public MustSetValidField(LocalizedValue fieldLabel, String fieldName) {
            super(String.format("There is no field name %s defined on form", fieldName));
            this._fieldLabel = fieldLabel;
            this._fieldName = fieldName;
        }

        public MustSetValidField(String fieldName) {
            this(null, fieldName);
        }

        public LocalizedValue getFieldLabel() {
            return this._fieldLabel;
        }

        public String getFieldLabelValue(Locale locale) {
            if (this._fieldLabel == null) {
                return "";
            }
            return this._fieldLabel.getString(locale);
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidDefaultLocale
    extends DDMFormValuesValidationException {
        private final LocalizedValue _fieldLabel;
        private String _fieldName;

        public MustSetValidDefaultLocale(LocalizedValue fieldLabel, String fieldName) {
            super(String.format("Invalid default locale set for field name %s", fieldName));
            this._fieldLabel = fieldLabel;
            this._fieldName = fieldName;
        }

        public MustSetValidDefaultLocale(String fieldName) {
            this(null, fieldName);
        }

        public LocalizedValue getFieldLabel() {
            return this._fieldLabel;
        }

        public String getFieldLabelValue(Locale locale) {
            if (this._fieldLabel == null) {
                return "";
            }
            return this._fieldLabel.getString(locale);
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustSetValidAvailableLocales
    extends DDMFormValuesValidationException {
        private final LocalizedValue _fieldLabel;
        private String _fieldName;

        public MustSetValidAvailableLocales(LocalizedValue fieldLabel, String fieldName) {
            super(String.format("Invalid available locales set for field name %s", fieldName));
            this._fieldLabel = fieldLabel;
            this._fieldName = fieldName;
        }

        public MustSetValidAvailableLocales(String fieldName) {
            this(null, fieldName);
        }

        public LocalizedValue getFieldLabel() {
            return this._fieldLabel;
        }

        public String getFieldLabelValue(Locale locale) {
            if (this._fieldLabel == null) {
                return "";
            }
            return this._fieldLabel.getString(locale);
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    public static class MustNotSetValue
    extends DDMFormValuesValidationException {
        private final LocalizedValue _fieldLabel;
        private String _fieldName;

        public MustNotSetValue(LocalizedValue fieldLabel, String fieldName) {
            super(String.format("Value should not be set for transient field name %s", fieldName));
            this._fieldLabel = fieldLabel;
            this._fieldName = fieldName;
        }

        public MustNotSetValue(String fieldName) {
            this(null, fieldName);
        }

        public LocalizedValue getFieldLabel() {
            return this._fieldLabel;
        }

        public String getFieldLabelValue(Locale locale) {
            if (this._fieldLabel == null) {
                return "";
            }
            return this._fieldLabel.getString(locale);
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }
}

