/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.webdav;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.webdav.DDMWebDAV;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", "webdav.storage.token=dynamic_data_lists"}, service={WebDAVStorage.class})
public class DDLWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMWebDAV _ddmWebDAV;
    @Reference
    private Portal _portal;

    public int deleteResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.deleteResource(webDAVRequest, this.getRootPath(), this.getToken(), this._portal.getClassNameId(DDLRecordSet.class));
    }

    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.getResource(webDAVRequest, this.getRootPath(), this.getToken(), this._portal.getClassNameId(DDLRecordSet.class));
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            String[] pathArray = webDAVRequest.getPathArray();
            if (pathArray.length == 2) {
                return this.getFolders(webDAVRequest);
            }
            if (pathArray.length == 3) {
                String type = pathArray[2];
                if (type.equals("Structures")) {
                    return this.getStructures(webDAVRequest);
                }
                if (type.equals("Templates")) {
                    return this.getTemplates(webDAVRequest);
                }
            }
            return new ArrayList<Resource>();
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int putResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.putResource(webDAVRequest, this.getRootPath(), this.getToken(), this._portal.getClassNameId(DDLRecordSet.class));
    }

    protected List<Resource> getFolders(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(this._ddmWebDAV.toResource(webDAVRequest, "Structures", this.getRootPath(), true));
        resources.add(this._ddmWebDAV.toResource(webDAVRequest, "Templates", this.getRootPath(), true));
        return resources;
    }

    protected List<Resource> getStructures(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List ddmStructures = this._ddmStructureLocalService.getStructures(webDAVRequest.getGroupId(), this._portal.getClassNameId(DDLRecordSet.class));
        for (DDMStructure ddmStructure : ddmStructures) {
            Resource resource = this._ddmWebDAV.toResource(webDAVRequest, ddmStructure, this.getRootPath(), true);
            resources.add(resource);
        }
        return resources;
    }

    protected List<Resource> getTemplates(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List ddmTemplates = this._ddmTemplateLocalService.getTemplatesByStructureClassNameId(webDAVRequest.getGroupId(), this._portal.getClassNameId(DDLRecordSet.class), 0, -1, -1, null);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            Resource resource = this._ddmWebDAV.toResource(webDAVRequest, ddmTemplate, this.getRootPath(), true);
            resources.add(resource);
        }
        return resources;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMWebDav(DDMWebDAV ddmWebDAV) {
        this._ddmWebDAV = ddmWebDAV;
    }
}

