/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.template;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRenderer;
import com.liferay.dynamic.data.mapping.render.DDMFormFieldValueRendererRegistryUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;

public class DDLDisplayTemplateHelper {
    private final DLURLHelper _dlURLHelper;

    public DDLDisplayTemplateHelper(DLURLHelper dlURLHelper) {
        this._dlURLHelper = dlURLHelper;
    }

    public String getDocumentLibraryPreviewURL(DDMFormFieldValue recordFieldValue, Locale locale) throws PortalException {
        Value value = recordFieldValue.getValue();
        String valueString = value.getString(locale);
        if (Validator.isNull((String)valueString)) {
            return "";
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
        String uuid = jsonObject.getString("uuid");
        long groupId = jsonObject.getLong("groupId");
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
        return this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, true);
    }

    public String getHTMLContent(DDMFormFieldValue recordFieldValue, Locale locale) {
        Value value = recordFieldValue.getValue();
        String valueString = value.getString(locale);
        if (Validator.isNull((String)valueString)) {
            return "";
        }
        return HtmlUtil.escapeJS((String)valueString);
    }

    public String getLayoutFriendlyURL(DDMFormFieldValue recordFieldValue, ThemeDisplay themeDisplay) throws PortalException {
        Value value = recordFieldValue.getValue();
        String valueString = value.getString(themeDisplay.getLocale());
        if (Validator.isNull((String)valueString)) {
            return "";
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
        long groupId = jsonObject.getLong("groupId");
        boolean privateLayout = jsonObject.getBoolean("privateLayout");
        long layoutId = jsonObject.getLong("layoutId");
        Layout layout = LayoutLocalServiceUtil.getLayout((long)groupId, (boolean)privateLayout, (long)layoutId);
        return PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
    }

    public List<DDLRecord> getRecords(long recordSetId) throws PortalException {
        return DDLRecordLocalServiceUtil.getRecords((long)recordSetId);
    }

    public List<DDLRecord> getRecords(long recordSetId, int status, int start, int end, OrderByComparator<DDLRecord> orderByComparator) throws PortalException {
        return DDLRecordLocalServiceUtil.getRecords((long)recordSetId, (int)status, (int)start, (int)end, orderByComparator);
    }

    public String renderRecordFieldValue(DDMFormFieldValue recordFieldValue, Locale locale) throws PortalException {
        DDMFormFieldValueRenderer ddmFormFieldValueRenderer = DDMFormFieldValueRendererRegistryUtil.getDDMFormFieldValueRenderer((String)recordFieldValue.getType());
        return ddmFormFieldValueRenderer.render(recordFieldValue, locale);
    }
}

