/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.portlet;

import com.liferay.dynamic.data.lists.exception.NoSuchRecordSetException;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.util.DDL;
import com.liferay.dynamic.data.lists.web.internal.configuration.activator.DDLWebConfigurationActivator;
import com.liferay.dynamic.data.lists.web.internal.display.context.DDLDisplayContext;
import com.liferay.dynamic.data.mapping.security.permission.DDMPermissionSupport;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMDisplayRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.PortletPreferencesException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import java.io.IOException;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"com.liferay.fragment.entry.processor.portlet.alias=dynamic-data-list", "com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-dynamic-data-lists-display", "com.liferay.portlet.display-category=category.collaboration", "com.liferay.portlet.header-portal-javascript=/o/dynamic-data-mapping-web/js/custom_fields.js", "com.liferay.portlet.header-portal-javascript=/o/dynamic-data-mapping-web/js/main.js", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.header-portlet-javascript=/js/main.js", "com.liferay.portlet.instanceable=true", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Dynamic Data Lists Display", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.copy-request-parameters=true", "javax.portlet.init-param.template-path=/", "javax.portlet.init-param.view-template=/view_selected_record_set.jsp", "javax.portlet.name=com_liferay_dynamic_data_lists_web_portlet_DDLDisplayPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=guest,power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class DDLDisplayPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(DDLDisplayPortlet.class);
    private DDL _ddl;
    private DDLRecordService _ddlRecordService;
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private DDLRecordSetService _ddlRecordSetService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="unsetDDLWebConfigurationActivator")
    private volatile DDLWebConfigurationActivator _ddlWebConfigurationActivator;
    private DDMDisplayRegistry _ddmDisplayRegistry;
    private DDMPermissionSupport _ddmPermissionSupport;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private Portal _portal;
    private StorageEngine _storageEngine;

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            this.setDDLRecordRequestAttribute(renderRequest);
            this.setDDLRecordSetRequestAttribute(renderRequest);
            DDLDisplayContext ddlDisplayContext = new DDLDisplayContext(renderRequest, renderResponse, this._ddl, this._ddlRecordSetLocalService, this._ddlWebConfigurationActivator.getDDLWebConfiguration(), this._ddmDisplayRegistry, this._ddmPermissionSupport, this._ddmTemplateLocalService, this._storageEngine);
            renderRequest.setAttribute("PORTLET_DISPLAY_CONTEXT", (Object)ddlDisplayContext);
        }
        catch (Exception e) {
            if (this.isSessionErrorException(e)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e, (Throwable)e);
                }
                this.hideDefaultErrorMessage((PortletRequest)renderRequest);
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
            }
            throw new PortletException((Throwable)e);
        }
        super.render(renderRequest, renderResponse);
    }

    @Reference(unbind="-")
    public void setDDL(DDL ddl) {
        this._ddl = ddl;
    }

    @Reference(unbind="-")
    public void setDDLRecordService(DDLRecordService ddlRecordService) {
        this._ddlRecordService = ddlRecordService;
    }

    @Reference(unbind="-")
    public void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(unbind="-")
    public void setDDMDisplayRegistry(DDMDisplayRegistry ddmDisplayRegistry) {
        this._ddmDisplayRegistry = ddmDisplayRegistry;
    }

    @Reference(unbind="-")
    public void setDDMPermissionSupport(DDMPermissionSupport ddmPermissionSupport) {
        this._ddmPermissionSupport = ddmPermissionSupport;
    }

    @Reference(unbind="-")
    public void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    public void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchRecordSetException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)PortletPreferencesException.MustBeStrict.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include(this.templatePath + "error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof NoSuchRecordSetException || cause instanceof PortletPreferencesException || cause instanceof PrincipalException;
    }

    protected void setDDLRecordRequestAttribute(RenderRequest renderRequest) throws PortalException {
        long recordId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"recordId");
        DDLRecord record = null;
        if (recordId > 0L) {
            record = this._ddlRecordService.getRecord(recordId);
        }
        renderRequest.setAttribute("DYNAMIC_DATA_LISTS_RECORD", record);
    }

    protected void setDDLRecordSetRequestAttribute(RenderRequest renderRequest) throws PortalException {
        long recordSetId = PrefsParamUtil.getLong((PortletPreferences)renderRequest.getPreferences(), (PortletRequest)renderRequest, (String)"recordSetId");
        DDLRecordSet recordSet = null;
        if (recordSetId > 0L) {
            recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        }
        renderRequest.setAttribute("DYNAMIC_DATA_LISTS_RECORD_SET", recordSet);
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }

    protected void unsetDDLWebConfigurationActivator(DDLWebConfigurationActivator ddlWebConfigurationActivator) {
        this._ddlWebConfigurationActivator = null;
    }
}

