/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.display.context;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalServiceUtil;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordCreateDateComparator;
import com.liferay.dynamic.data.lists.util.comparator.DDLRecordModifiedDateComparator;
import com.liferay.dynamic.data.lists.web.internal.display.context.util.DDLRequestHelper;
import com.liferay.dynamic.data.lists.web.internal.search.RecordSearch;
import com.liferay.dynamic.data.lists.web.internal.security.permission.resource.DDLRecordSetPermission;
import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DDLViewRecordsDisplayContext {
    private static final int _TOTAL_COLUMNS = 5;
    private final DDLRecordSet _ddlRecordSet;
    private final DDLRequestHelper _ddlRequestHelper;
    private List<DDMFormField> _ddmFormFields;
    private final DDMStructure _ddmStructure;
    private final long _formDDMTemplateId;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final User _user;

    public DDLViewRecordsDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long formDDMTemplateId) throws PortalException {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._ddlRecordSet = (DDLRecordSet)this._liferayPortletRequest.getAttribute("DYNAMIC_DATA_LISTS_RECORD_SET");
        this._ddlRequestHelper = new DDLRequestHelper(PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest));
        this._ddmStructure = this._ddlRecordSet.getDDMStructure(formDDMTemplateId);
        this._formDDMTemplateId = formDDMTemplateId;
        User user = PortalUtil.getUser((PortletRequest)liferayPortletRequest);
        if (user == null) {
            ThemeDisplay themeDisplay = this._ddlRequestHelper.getThemeDisplay();
            user = themeDisplay.getDefaultUser();
        }
        this._user = user;
    }

    public List<DropdownItem> getActionItemsDropdownItems() throws PortalException {
        if (!this.hasDeletePermission()) {
            return null;
        }
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteRecords");
                    dropdownItem.setIcon("trash");
                    dropdownItem.setLabel("delete");
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClearResultsURL() throws PortletException {
        PortletURL clearResultsURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (LiferayPortletResponse)this._liferayPortletResponse);
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() throws PortalException {
        if (!this.isShowAddRecordButton()) {
            return null;
        }
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(DDLViewRecordsDisplayContext.this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_record.jsp", "redirect", PortalUtil.getCurrentURL((HttpServletRequest)DDLViewRecordsDisplayContext.this._ddlRequestHelper.getRequest()), "recordSetId", String.valueOf(DDLViewRecordsDisplayContext.this._ddlRecordSet.getRecordSetId()), "formDDMTemplateId", String.valueOf(DDLViewRecordsDisplayContext.this._formDDMTemplateId)});
                    dropdownItem.setLabel(LanguageUtil.format((HttpServletRequest)DDLViewRecordsDisplayContext.this._ddlRequestHelper.getRequest(), (String)"add-x", (Object)HtmlUtil.escape((String)DDLViewRecordsDisplayContext.this._ddmStructure.getName(DDLViewRecordsDisplayContext.this._ddlRequestHelper.getLocale())), (boolean)false));
                });
            }
        };
    }

    public OrderByComparator<DDLRecord> getDDLRecordOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = orderByCol.equals("modified-date") ? new DDLRecordModifiedDateComparator(orderByAsc) : new DDLRecordCreateDateComparator(orderByAsc);
        return orderByComparator;
    }

    public List<DDMFormField> getDDMFormFields() {
        if (this._ddmFormFields == null) {
            DDMForm ddmForm = this._ddmStructure.getDDMForm();
            ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
            for (DDMFormField ddmFormField : ddmForm.getDDMFormFields()) {
                this.addDDMFormField(ddmFormFields, ddmFormField);
            }
            int totalColumns = 5;
            if (ddmFormFields.size() < totalColumns) {
                totalColumns = ddmFormFields.size();
            }
            this._ddmFormFields = ddmFormFields.subList(0, totalColumns);
        }
        return this._ddmFormFields;
    }

    public Map<String, List<DDMFormFieldValue>> getDDMFormFieldValuesMap(DDLRecordVersion recordVersion) throws StorageException {
        DDMFormValues ddmFormValues = recordVersion.getDDMFormValues();
        List ddmFormFieldValues = ddmFormValues.getDDMFormFieldValues();
        LinkedHashMap<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap = new LinkedHashMap<String, List<DDMFormFieldValue>>();
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            this.putDDMFormFieldValue(ddmFormFieldValuesMap, ddmFormFieldValue);
        }
        return ddmFormFieldValuesMap;
    }

    public DDMStructure getDDMStructure() {
        return this._ddmStructure;
    }

    public String getDisplayStyle() {
        return "list";
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        final HttpServletRequest request = this._ddlRequestHelper.getRequest();
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDLViewRecordsDisplayContext.this.getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(DDLViewRecordsDisplayContext.this.getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)request, (String)"order-by"));
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(HtmlUtil.extractText((String)DDLViewRecordsDisplayContext.this._ddlRecordSet.getName(DDLViewRecordsDisplayContext.this._ddlRequestHelper.getLocale())));
                });
            }
        };
    }

    public String getOrderByCol() {
        String orderByCol = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByCol", (String)"modified-date");
        return orderByCol;
    }

    public String getOrderByType() {
        String orderByType = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByType", (String)"asc");
        return orderByType;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        String keywords;
        String displayStyle;
        PortletURL portletURL = PortletURLUtil.getCurrent((LiferayPortletRequest)this._liferayPortletRequest, (LiferayPortletResponse)this._liferayPortletResponse);
        portletURL.setParameter("mvcPath", this.getMVCPath());
        portletURL.setParameter("redirect", ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"redirect"));
        portletURL.setParameter("recordSetId", String.valueOf(this._ddlRecordSet.getRecordSetId()));
        String delta = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"delta");
        if (Validator.isNotNull((String)delta)) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(displayStyle = this.getDisplayStyle()))) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        if (Validator.isNotNull((String)(keywords = this.getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public SearchContainer<?> getSearch() throws PortalException {
        String displayStyle = this.getDisplayStyle();
        PortletURL portletURL = this.getPortletURL();
        portletURL.setParameter("displayStyle", displayStyle);
        ArrayList<String> headerNames = new ArrayList<String>();
        List<DDMFormField> ddmFormFields = this.getDDMFormFields();
        for (DDMFormField ddmFormField : ddmFormFields) {
            LocalizedValue label = ddmFormField.getLabel();
            headerNames.add(label.getString(this._ddlRequestHelper.getLocale()));
        }
        if (this.hasUpdatePermission()) {
            headerNames.add("status");
            headerNames.add("modified-date");
            headerNames.add("author");
        }
        headerNames.add("");
        RecordSearch recordSearch = new RecordSearch((PortletRequest)this._liferayPortletRequest, portletURL, headerNames);
        if (!this._user.isDefaultUser()) {
            recordSearch.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._liferayPortletResponse));
        }
        OrderByComparator<DDLRecord> orderByComparator = this.getDDLRecordOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        recordSearch.setOrderByCol(this.getOrderByCol());
        recordSearch.setOrderByComparator(orderByComparator);
        recordSearch.setOrderByType(this.getOrderByType());
        if (recordSearch.isSearch()) {
            recordSearch.setEmptyResultsMessage(LanguageUtil.format((Locale)this._ddlRequestHelper.getLocale(), (String)"no-x-records-were-found", (Object)this._ddlRecordSet.getName(), (boolean)false));
        } else {
            recordSearch.setEmptyResultsMessage("there-are-no-records");
        }
        this.setDDLRecordSearchResults(recordSearch);
        this.setDDLRecordSearchTotal(recordSearch);
        return recordSearch;
    }

    public String getSearchActionURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", this.getMVCPath());
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((PortletRequest)this._liferayPortletRequest));
        portletURL.setParameter("recordSetId", String.valueOf(this._ddlRecordSet.getRecordSetId()));
        return portletURL.toString();
    }

    public String getSearchContainerId() {
        return "ddlRecord";
    }

    public String getSortingURL() throws Exception {
        PortletURL sortingURL = PortletURLUtil.clone((PortletURL)this.getPortletURL(), (LiferayPortletResponse)this._liferayPortletResponse);
        String orderByType = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"orderByType");
        sortingURL.setParameter("orderByType", orderByType.equals("asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() throws PortalException {
        SearchContainer<?> searchContainer = this.getSearch();
        return searchContainer.getTotal();
    }

    public boolean hasDeletePermission() throws PortalException {
        boolean hasDeletePermission = false;
        if (this.isEditable() || this.isAdminPortlet()) {
            hasDeletePermission = DDLRecordSetPermission.contains(this.getPermissionChecker(), this._ddlRecordSet.getRecordSetId(), "DELETE");
        }
        return hasDeletePermission;
    }

    public boolean hasUpdatePermission() throws PortalException {
        boolean hasUpdatePermission = false;
        if (this.isEditable() || this.isAdminPortlet()) {
            hasUpdatePermission = DDLRecordSetPermission.contains(this.getPermissionChecker(), this._ddlRecordSet.getRecordSetId(), "UPDATE");
        }
        return hasUpdatePermission;
    }

    public boolean isAdminPortlet() {
        String portletName = this.getPortletName();
        return portletName.equals("com_liferay_dynamic_data_lists_web_portlet_DDLPortlet");
    }

    public boolean isDisabledManagementBar() throws PortalException {
        if (this.hasResults()) {
            return false;
        }
        return !this.isSearch();
    }

    public boolean isEditable() {
        if (this.isAdminPortlet()) {
            return true;
        }
        return PrefsParamUtil.getBoolean((PortletPreferences)this._ddlRequestHelper.getPortletPreferences(), (PortletRequest)this._ddlRequestHelper.getRenderRequest(), (String)"editable", (boolean)true);
    }

    public boolean isSelectable() {
        return !this._user.isDefaultUser();
    }

    protected void addDDMFormField(List<DDMFormField> ddmFormFields, DDMFormField ddmFormField) {
        if (!this.isDDMFormFieldTransient(ddmFormField)) {
            ddmFormFields.add(ddmFormField);
            return;
        }
        for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
            this.addDDMFormField(ddmFormFields, nestedDDMFormField);
        }
    }

    protected List<DropdownItem> getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(DDLViewRecordsDisplayContext.this.getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)DDLViewRecordsDisplayContext.this._ddlRequestHelper.getRequest(), (String)"all"));
                });
            }
        };
    }

    protected String getKeywords() {
        return ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"keywords");
    }

    protected String getMVCPath() {
        if (this.isAdminPortlet()) {
            return "/view_record_set.jsp";
        }
        return "/view_selected_record_set.jsp";
    }

    protected Consumer<DropdownItem> getOrderByDropdownItem(String orderByCol) {
        return dropdownItem -> {
            dropdownItem.setActive(orderByCol.equals(this.getOrderByCol()));
            dropdownItem.setHref(this.getPortletURL(), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._ddlRequestHelper.getRequest(), (String)orderByCol));
        };
    }

    protected List<DropdownItem> getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(DDLViewRecordsDisplayContext.this.getOrderByDropdownItem("create-date"));
                this.add(DDLViewRecordsDisplayContext.this.getOrderByDropdownItem("modified-date"));
            }
        };
    }

    protected PermissionChecker getPermissionChecker() {
        return this._ddlRequestHelper.getPermissionChecker();
    }

    protected String getPortletName() {
        return this._ddlRequestHelper.getPortletName();
    }

    protected SearchContext getSearchContext(SearchContainer recordSearch, int status) {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._ddlRequestHelper.getRequest());
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        searchContext.setAttribute("recordSetId", (Serializable)Long.valueOf(this._ddlRecordSet.getRecordSetId()));
        searchContext.setAttribute("recordSetScope", (Serializable)Integer.valueOf(this._ddlRecordSet.getScope()));
        searchContext.setEnd(recordSearch.getEnd());
        searchContext.setKeywords(this.getKeywords());
        searchContext.setStart(recordSearch.getStart());
        return searchContext;
    }

    protected boolean hasResults() throws PortalException {
        return this.getTotalItems() > 0;
    }

    protected boolean isDDMFormFieldTransient(DDMFormField ddmFormField) {
        return Validator.isNull((String)ddmFormField.getDataType());
    }

    protected boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    protected boolean isShowAddRecordButton() throws PortalException {
        boolean showAddRecordButton = false;
        if (this.isEditable()) {
            showAddRecordButton = DDLRecordSetPermission.contains(this.getPermissionChecker(), this._ddlRecordSet.getRecordSetId(), "ADD_RECORD");
        }
        return showAddRecordButton;
    }

    protected void putDDMFormFieldValue(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, DDMFormFieldValue ddmFormFieldValue) {
        List<DDMFormFieldValue> ddmFormFieldValues = ddmFormFieldValuesMap.get(ddmFormFieldValue.getName());
        if (ddmFormFieldValues == null) {
            ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
            ddmFormFieldValuesMap.put(ddmFormFieldValue.getName(), ddmFormFieldValues);
        }
        ddmFormFieldValues.add(ddmFormFieldValue);
        for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
            this.putDDMFormFieldValue(ddmFormFieldValuesMap, nestedDDMFormFieldValue);
        }
    }

    protected void setDDLRecordSearchResults(SearchContainer recordSearch) throws PortalException {
        List results = null;
        DisplayTerms displayTerms = recordSearch.getDisplayTerms();
        int status = 0;
        if (this.isShowAddRecordButton()) {
            status = -1;
        }
        if (Validator.isNull((String)displayTerms.getKeywords())) {
            results = DDLRecordLocalServiceUtil.getRecords((long)this._ddlRecordSet.getRecordSetId(), (int)status, (int)recordSearch.getStart(), (int)recordSearch.getEnd(), (OrderByComparator)recordSearch.getOrderByComparator());
        } else {
            SearchContext searchContext = this.getSearchContext(recordSearch, status);
            BaseModelSearchResult baseModelSearchResult = DDLRecordLocalServiceUtil.searchDDLRecords((SearchContext)searchContext);
            results = baseModelSearchResult.getBaseModels();
        }
        recordSearch.setResults(results);
    }

    protected void setDDLRecordSearchTotal(SearchContainer recordSearch) throws PortalException {
        int total;
        DisplayTerms displayTerms = recordSearch.getDisplayTerms();
        int status = 0;
        if (this.isShowAddRecordButton()) {
            status = -1;
        }
        if (Validator.isNull((String)displayTerms.getKeywords())) {
            total = DDLRecordLocalServiceUtil.getRecordsCount((long)this._ddlRecordSet.getRecordSetId(), (int)status);
        } else {
            SearchContext searchContext = this.getSearchContext(recordSearch, status);
            BaseModelSearchResult baseModelSearchResult = DDLRecordLocalServiceUtil.searchDDLRecords((SearchContext)searchContext);
            total = baseModelSearchResult.getLength();
        }
        recordSearch.setTotal(total);
    }
}

