/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_web_portlet_DDLDisplayPortlet"}, service={ExportImportPortletPreferencesProcessor.class})
public class DDLDisplayExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(DDLDisplayExportImportPortletPreferencesProcessor.class);
    @Reference(target="(name=ReferencedStagedModelImporter)")
    private Capability _capability;
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    private StagedModelRepository<DDLRecord> _ddlRecordStagedModelRepository;
    private DDMTemplateLocalService _ddmTemplateLocalService;

    public List<Capability> getExportCapabilities() {
        return null;
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._capability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.addPortletPermissions("com.liferay.dynamic.data.lists");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        String portletId = portletDataContext.getPortletId();
        long recordSetId = GetterUtil.getLong((String)portletPreferences.getValue("recordSetId", null));
        if (recordSetId == 0L) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Record set ID is not set for preferences of portlet " + portletId));
            }
            return portletPreferences;
        }
        DDLRecordSet recordSet = this._ddlRecordSetLocalService.fetchRecordSet(recordSetId);
        if (recordSet != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)recordSet);
            ActionableDynamicQuery recordActionableDynamicQuery = this.getRecordActionableDynamicQuery(portletDataContext, recordSet, portletId);
            try {
                recordActionableDynamicQuery.performActions();
            }
            catch (PortalException pe) {
                throw new PortletDataException("Unable to export referenced records", (Throwable)pe);
            }
        }
        long displayDDMTemplateId = GetterUtil.getLong((String)portletPreferences.getValue("displayDDMTemplateId", null));
        this._exportReferenceDDMTemplate(portletDataContext, portletId, displayDDMTemplateId);
        long formDDMTemplateId = GetterUtil.getLong((String)portletPreferences.getValue("formDDMTemplateId", null));
        this._exportReferenceDDMTemplate(portletDataContext, portletId, formDDMTemplateId);
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            portletDataContext.importPortletPermissions("com.liferay.dynamic.data.lists");
        }
        catch (PortalException pe) {
            throw new PortletDataException("Unable to export portlet permissions", (Throwable)pe);
        }
        long importedRecordSetId = GetterUtil.getLong((String)portletPreferences.getValue("recordSetId", null));
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        long recordSetId = MapUtil.getLong((Map)recordSetIds, (long)importedRecordSetId, (long)importedRecordSetId);
        Map templateIds = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class);
        long importedDisplayDDMTemplateId = GetterUtil.getLong((String)portletPreferences.getValue("displayDDMTemplateId", null));
        long displayDDMTemplateId = MapUtil.getLong((Map)templateIds, (long)importedDisplayDDMTemplateId, (long)importedDisplayDDMTemplateId);
        long importedFormDDMTemplateId = GetterUtil.getLong((String)portletPreferences.getValue("formDDMTemplateId", null));
        long formDDMTemplateId = MapUtil.getLong((Map)templateIds, (long)importedFormDDMTemplateId, (long)importedFormDDMTemplateId);
        try {
            portletPreferences.setValue("recordSetId", String.valueOf(recordSetId));
            portletPreferences.setValue("displayDDMTemplateId", String.valueOf(displayDDMTemplateId));
            portletPreferences.setValue("formDDMTemplateId", String.valueOf(formDDMTemplateId));
        }
        catch (ReadOnlyException roe) {
            throw new PortletDataException("Unable to update portlet preferences during import", (Throwable)roe);
        }
        return portletPreferences;
    }

    protected ActionableDynamicQuery getRecordActionableDynamicQuery(PortletDataContext portletDataContext, DDLRecordSet recordSet, String portletId) {
        ExportActionableDynamicQuery recordActionableDynamicQuery = this._ddlRecordStagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
        ActionableDynamicQuery.AddCriteriaMethod addCriteriaMethod = recordActionableDynamicQuery.getAddCriteriaMethod();
        recordActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            addCriteriaMethod.addCriteria(dynamicQuery);
            Property property = PropertyFactoryUtil.forName((String)"recordSetId");
            dynamicQuery.add(property.eq((Object)recordSet.getRecordSetId()));
        });
        recordActionableDynamicQuery.setGroupId(recordSet.getGroupId());
        recordActionableDynamicQuery.setPerformActionMethod(record -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)record));
        return recordActionableDynamicQuery;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetLocalService(DDLRecordSetLocalService ddlRecordSetLocalService) {
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
    }

    @Reference(target="(model.class.name=com.liferay.dynamic.data.lists.model.DDLRecord)", unbind="-")
    protected void setDDLRecordStagedModelRepository(StagedModelRepository<DDLRecord> ddlRecordStagedModelRepository) {
        this._ddlRecordStagedModelRepository = ddlRecordStagedModelRepository;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    private void _exportReferenceDDMTemplate(PortletDataContext portletDataContext, String portletId, long ddmTemplateId) throws PortletDataException {
        if (ddmTemplateId == 0L) {
            return;
        }
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(ddmTemplateId);
        if (ddmTemplate == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to export referenced template " + ddmTemplateId));
            }
            return;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)ddmTemplate);
    }
}

