/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.template;

import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.web.configuration.DDLWebConfigurationUtil;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.templateparser.Transformer;
import java.util.HashMap;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;

public class DDLDisplayTemplateTransformer {
    private final long _ddmTemplateId;
    private final DDLRecordSet _recordSet;
    private final RenderRequest _renderRequest;
    private final ThemeDisplay _themeDisplay;

    public DDLDisplayTemplateTransformer(long ddmTemplateId, DDLRecordSet recordSet, ThemeDisplay themeDisplay, RenderRequest renderRequest) {
        this._ddmTemplateId = ddmTemplateId;
        this._recordSet = recordSet;
        this._themeDisplay = themeDisplay;
        this._renderRequest = renderRequest;
    }

    public String transform() throws Exception {
        Transformer transformer = TransformerHolder.getTransformer();
        HashMap<String, Object> contextObjects = new HashMap<String, Object>();
        contextObjects.put("reserved_ddm_structure_id", this._recordSet.getDDMStructureId());
        contextObjects.put("reserved_ddm_template_id", this._ddmTemplateId);
        contextObjects.put("reserved_record_set_description", this._recordSet.getDescription(this._themeDisplay.getLocale()));
        contextObjects.put("reserved_record_set_id", this._recordSet.getRecordSetId());
        contextObjects.put("reserved_record_set_name", this._recordSet.getName(this._themeDisplay.getLocale()));
        contextObjects.put("template_id", this._ddmTemplateId);
        String viewMode = "view";
        if (this._renderRequest != null) {
            viewMode = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"viewMode", (String)"view");
        }
        contextObjects.put("viewMode", viewMode);
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.getTemplate((long)this._ddmTemplateId);
        contextObjects.put("class_name_id", ddmTemplate.getClassNameId());
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)ddmTemplate.getLanguage());
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((String)DDLRecordSet.class.getName());
        templateManager.addContextObjects(contextObjects, templateHandler.getCustomContextObjects());
        templateManager.addTaglibSupport(contextObjects, PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest), this._themeDisplay.getResponse());
        return transformer.transform(this._themeDisplay, contextObjects, ddmTemplate.getScript(), ddmTemplate.getLanguage(), new UnsyncStringWriter());
    }

    private static class TransformerHolder {
        private static final Transformer _transformer = new Transformer("dynamic.data.lists.error.template", true){

            protected String getErrorTemplateId(String errorTemplatePropertyKey, String langType) {
                return DDLWebConfigurationUtil.get(errorTemplatePropertyKey, new Filter(langType));
            }
        };

        private TransformerHolder() {
        }

        public static Transformer getTransformer() {
            return _transformer;
        }
    }
}

