/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dynamic.data.lists.web.internal.portlet.action;

import com.liferay.dynamic.data.lists.exporter.DDLExporter;
import com.liferay.dynamic.data.lists.exporter.DDLExporterFactory;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetService;
import com.liferay.dynamic.data.lists.web.configuration.DDLWebConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.dynamic.data.lists.web.configuration.DDLWebConfiguration"}, immediate=true, property={"javax.portlet.name=com_liferay_dynamic_data_lists_web_portlet_DDLPortlet", "javax.portlet.name=com_liferay_dynamic_data_lists_web_portlet_DDLDisplayPortlet", "mvc.command.name=exportRecordSet"}, service={MVCResourceCommand.class})
public class ExportRecordSetMVCResourceCommand
extends BaseMVCResourceCommand {
    private DDLExporterFactory _ddlExporterFactory;
    private DDLRecordSetService _ddlRecordSetService;
    private volatile DDLWebConfiguration _ddlWebConfiguration;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._ddlWebConfiguration = (DDLWebConfiguration)ConfigurableUtil.createConfigurable(DDLWebConfiguration.class, properties);
    }

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long recordSetId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"recordSetId");
        DDLRecordSet recordSet = this._ddlRecordSetService.getRecordSet(recordSetId);
        String fileExtension = ParamUtil.getString((PortletRequest)resourceRequest, (String)"fileExtension");
        if (StringUtil.equals((String)fileExtension, (String)"csv") && StringUtil.equals((String)this._ddlWebConfiguration.csvExport(), (String)"disabled")) {
            return;
        }
        String fileName = recordSet.getName(themeDisplay.getLocale()) + '.' + fileExtension;
        DDLExporter exporter = this._ddlExporterFactory.getDDLExporter(fileExtension);
        exporter.setLocale(themeDisplay.getLocale());
        byte[] bytes = exporter.export(recordSetId, 0);
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        PortletResponseUtil.sendFile((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (String)fileName, (byte[])bytes, (String)contentType);
    }

    @Reference(unbind="-")
    protected void setDDLExporterFactory(DDLExporterFactory ddlExporterFactory) {
        this._ddlExporterFactory = ddlExporterFactory;
    }

    @Reference(unbind="-")
    protected void setDDLRecordSetService(DDLRecordSetService ddlRecordSetService) {
        this._ddlRecordSetService = ddlRecordSetService;
    }
}

